// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A configuration for Amazon SNS-integrated notifications.
 */
public class Alert private constructor(builder: Builder) {
    /**
     * Action that will be triggered when there is an alert.
     */
    public val action: aws.sdk.kotlin.services.lookoutmetrics.model.Action? = builder.action
    /**
     * The ARN of the alert.
     */
    public val alertArn: kotlin.String? = builder.alertArn
    /**
     * A description of the alert.
     */
    public val alertDescription: kotlin.String? = builder.alertDescription
    /**
     * The configuration of the alert filters, containing MetricList and DimensionFilter.
     */
    public val alertFilters: aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters? = builder.alertFilters
    /**
     * The name of the alert.
     */
    public val alertName: kotlin.String? = builder.alertName
    /**
     * The minimum severity for an anomaly to trigger the alert.
     */
    public val alertSensitivityThreshold: kotlin.Int = builder.alertSensitivityThreshold
    /**
     * The status of the alert.
     */
    public val alertStatus: aws.sdk.kotlin.services.lookoutmetrics.model.AlertStatus? = builder.alertStatus
    /**
     * The type of the alert.
     */
    public val alertType: aws.sdk.kotlin.services.lookoutmetrics.model.AlertType? = builder.alertType
    /**
     * The ARN of the detector to which the alert is attached.
     */
    public val anomalyDetectorArn: kotlin.String? = builder.anomalyDetectorArn
    /**
     * The time at which the alert was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time at which the alert was last modified.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutmetrics.model.Alert = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Alert(")
        append("action=$action,")
        append("alertArn=$alertArn,")
        append("alertDescription=$alertDescription,")
        append("alertFilters=$alertFilters,")
        append("alertName=$alertName,")
        append("alertSensitivityThreshold=$alertSensitivityThreshold,")
        append("alertStatus=$alertStatus,")
        append("alertType=$alertType,")
        append("anomalyDetectorArn=$anomalyDetectorArn,")
        append("creationTime=$creationTime,")
        append("lastModificationTime=$lastModificationTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (alertArn?.hashCode() ?: 0)
        result = 31 * result + (alertDescription?.hashCode() ?: 0)
        result = 31 * result + (alertFilters?.hashCode() ?: 0)
        result = 31 * result + (alertName?.hashCode() ?: 0)
        result = 31 * result + (alertSensitivityThreshold)
        result = 31 * result + (alertStatus?.hashCode() ?: 0)
        result = 31 * result + (alertType?.hashCode() ?: 0)
        result = 31 * result + (anomalyDetectorArn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Alert

        if (action != other.action) return false
        if (alertArn != other.alertArn) return false
        if (alertDescription != other.alertDescription) return false
        if (alertFilters != other.alertFilters) return false
        if (alertName != other.alertName) return false
        if (alertSensitivityThreshold != other.alertSensitivityThreshold) return false
        if (alertStatus != other.alertStatus) return false
        if (alertType != other.alertType) return false
        if (anomalyDetectorArn != other.anomalyDetectorArn) return false
        if (creationTime != other.creationTime) return false
        if (lastModificationTime != other.lastModificationTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutmetrics.model.Alert = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Action that will be triggered when there is an alert.
         */
        public var action: aws.sdk.kotlin.services.lookoutmetrics.model.Action? = null
        /**
         * The ARN of the alert.
         */
        public var alertArn: kotlin.String? = null
        /**
         * A description of the alert.
         */
        public var alertDescription: kotlin.String? = null
        /**
         * The configuration of the alert filters, containing MetricList and DimensionFilter.
         */
        public var alertFilters: aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters? = null
        /**
         * The name of the alert.
         */
        public var alertName: kotlin.String? = null
        /**
         * The minimum severity for an anomaly to trigger the alert.
         */
        public var alertSensitivityThreshold: kotlin.Int = 0
        /**
         * The status of the alert.
         */
        public var alertStatus: aws.sdk.kotlin.services.lookoutmetrics.model.AlertStatus? = null
        /**
         * The type of the alert.
         */
        public var alertType: aws.sdk.kotlin.services.lookoutmetrics.model.AlertType? = null
        /**
         * The ARN of the detector to which the alert is attached.
         */
        public var anomalyDetectorArn: kotlin.String? = null
        /**
         * The time at which the alert was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which the alert was last modified.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutmetrics.model.Alert) : this() {
            this.action = x.action
            this.alertArn = x.alertArn
            this.alertDescription = x.alertDescription
            this.alertFilters = x.alertFilters
            this.alertName = x.alertName
            this.alertSensitivityThreshold = x.alertSensitivityThreshold
            this.alertStatus = x.alertStatus
            this.alertType = x.alertType
            this.anomalyDetectorArn = x.anomalyDetectorArn
            this.creationTime = x.creationTime
            this.lastModificationTime = x.lastModificationTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutmetrics.model.Alert = Alert(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutmetrics.model.Action] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.lookoutmetrics.model.Action.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.lookoutmetrics.model.Action.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters] inside the given [block]
         */
        public fun alertFilters(block: aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters.Builder.() -> kotlin.Unit) {
            this.alertFilters = aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
