// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.serde

import aws.sdk.kotlin.services.location.model.DistanceUnit
import aws.sdk.kotlin.services.location.model.InferredState
import aws.sdk.kotlin.services.location.model.LocationException
import aws.sdk.kotlin.services.location.model.VerifyDevicePositionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class VerifyDevicePositionOperationDeserializer: HttpDeserializer.NonStreaming<VerifyDevicePositionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): VerifyDevicePositionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwVerifyDevicePositionError(context, call, payload)
        }
        val builder = VerifyDevicePositionResponse.Builder()

        if (payload != null) {
            deserializeVerifyDevicePositionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwVerifyDevicePositionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LocationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LocationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeVerifyDevicePositionOperationBody(builder: VerifyDevicePositionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceId"))
    val DISTANCEUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DistanceUnit"))
    val INFERREDSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InferredState"))
    val RECEIVEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ReceivedTime"))
    val SAMPLETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("SampleTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICEID_DESCRIPTOR)
        field(DISTANCEUNIT_DESCRIPTOR)
        field(INFERREDSTATE_DESCRIPTOR)
        field(RECEIVEDTIME_DESCRIPTOR)
        field(SAMPLETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEVICEID_DESCRIPTOR.index -> builder.deviceId = deserializeString()
                DISTANCEUNIT_DESCRIPTOR.index -> builder.distanceUnit = deserializeString().let { DistanceUnit.fromValue(it) }
                INFERREDSTATE_DESCRIPTOR.index -> builder.inferredState = deserializeInferredStateDocument(deserializer)
                RECEIVEDTIME_DESCRIPTOR.index -> builder.receivedTime = deserializeInstant(TimestampFormat.ISO_8601)
                SAMPLETIME_DESCRIPTOR.index -> builder.sampleTime = deserializeInstant(TimestampFormat.ISO_8601)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
