// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.serde

import aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions
import aws.sdk.kotlin.services.location.model.CalculateRouteRequest
import aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions
import aws.sdk.kotlin.services.location.model.DistanceUnit
import aws.sdk.kotlin.services.location.model.OptimizationMode
import aws.sdk.kotlin.services.location.model.TravelMode
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CalculateRouteOperationSerializer: HttpSerializer.NonStreaming<CalculateRouteRequest> {
    override fun serialize(context: ExecutionContext, input: CalculateRouteRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("routes"))
                add(PercentEncoding.Path.encode("v0"))
                add(PercentEncoding.Path.encode("calculators"))
                add(PercentEncoding.SmithyLabel.encode(input.calculatorName))
                add(PercentEncoding.Path.encode("calculate"))
                add(PercentEncoding.Path.encode("route"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.key != null) add("key", input.key)
            }
        }

        val payload = serializeCalculateRouteOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCalculateRouteOperationBody(context: ExecutionContext, input: CalculateRouteRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARRIVALTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ArrivalTime"))
    val CARMODEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CarModeOptions"))
    val DEPARTNOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DepartNow"))
    val DEPARTUREPOSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DeparturePosition"))
    val DEPARTURETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DepartureTime"))
    val DESTINATIONPOSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DestinationPosition"))
    val DISTANCEUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DistanceUnit"))
    val INCLUDELEGGEOMETRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeLegGeometry"))
    val OPTIMIZEFOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptimizeFor"))
    val TRAVELMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TravelMode"))
    val TRUCKMODEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TruckModeOptions"))
    val WAYPOINTPOSITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WaypointPositions"))
    val WAYPOINTPOSITIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARRIVALTIME_DESCRIPTOR)
        field(CARMODEOPTIONS_DESCRIPTOR)
        field(DEPARTNOW_DESCRIPTOR)
        field(DEPARTUREPOSITION_DESCRIPTOR)
        field(DEPARTURETIME_DESCRIPTOR)
        field(DESTINATIONPOSITION_DESCRIPTOR)
        field(DISTANCEUNIT_DESCRIPTOR)
        field(INCLUDELEGGEOMETRY_DESCRIPTOR)
        field(OPTIMIZEFOR_DESCRIPTOR)
        field(TRAVELMODE_DESCRIPTOR)
        field(TRUCKMODEOPTIONS_DESCRIPTOR)
        field(WAYPOINTPOSITIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.arrivalTime?.let { field(ARRIVALTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.carModeOptions?.let { field(CARMODEOPTIONS_DESCRIPTOR, it, ::serializeCalculateRouteCarModeOptionsDocument) }
        input.departNow?.let { field(DEPARTNOW_DESCRIPTOR, it) }
        listField(DEPARTUREPOSITION_DESCRIPTOR) {
            for (el0 in input.departurePosition) {
                serializeDouble(el0)
            }
        }
        input.departureTime?.let { field(DEPARTURETIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        listField(DESTINATIONPOSITION_DESCRIPTOR) {
            for (el0 in input.destinationPosition) {
                serializeDouble(el0)
            }
        }
        input.distanceUnit?.let { field(DISTANCEUNIT_DESCRIPTOR, it.value) }
        input.includeLegGeometry?.let { field(INCLUDELEGGEOMETRY_DESCRIPTOR, it) }
        input.optimizeFor?.let { field(OPTIMIZEFOR_DESCRIPTOR, it.value) }
        input.travelMode?.let { field(TRAVELMODE_DESCRIPTOR, it.value) }
        input.truckModeOptions?.let { field(TRUCKMODEOPTIONS_DESCRIPTOR, it, ::serializeCalculateRouteTruckModeOptionsDocument) }
        if (input.waypointPositions != null) {
            listField(WAYPOINTPOSITIONS_DESCRIPTOR) {
                for (el0 in input.waypointPositions) {
                    serializer.serializeList(WAYPOINTPOSITIONS_C0_DESCRIPTOR) {
                        for (el1 in el0) {
                            serializeDouble(el1)
                        }
                    }
                }
            }
        }
    }
    return serializer.toByteArray()
}
