// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.paginators

import aws.sdk.kotlin.services.location.LocationClient
import aws.sdk.kotlin.services.location.model.DevicePosition
import aws.sdk.kotlin.services.location.model.ForecastGeofenceEventsRequest
import aws.sdk.kotlin.services.location.model.ForecastGeofenceEventsResponse
import aws.sdk.kotlin.services.location.model.ForecastedEvent
import aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryRequest
import aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryResponse
import aws.sdk.kotlin.services.location.model.ListDevicePositionsRequest
import aws.sdk.kotlin.services.location.model.ListDevicePositionsResponse
import aws.sdk.kotlin.services.location.model.ListDevicePositionsResponseEntry
import aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsRequest
import aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsResponse
import aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsResponseEntry
import aws.sdk.kotlin.services.location.model.ListGeofenceResponseEntry
import aws.sdk.kotlin.services.location.model.ListGeofencesRequest
import aws.sdk.kotlin.services.location.model.ListGeofencesResponse
import aws.sdk.kotlin.services.location.model.ListKeysRequest
import aws.sdk.kotlin.services.location.model.ListKeysResponse
import aws.sdk.kotlin.services.location.model.ListKeysResponseEntry
import aws.sdk.kotlin.services.location.model.ListMapsRequest
import aws.sdk.kotlin.services.location.model.ListMapsResponse
import aws.sdk.kotlin.services.location.model.ListMapsResponseEntry
import aws.sdk.kotlin.services.location.model.ListPlaceIndexesRequest
import aws.sdk.kotlin.services.location.model.ListPlaceIndexesResponse
import aws.sdk.kotlin.services.location.model.ListPlaceIndexesResponseEntry
import aws.sdk.kotlin.services.location.model.ListRouteCalculatorsRequest
import aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponse
import aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponseEntry
import aws.sdk.kotlin.services.location.model.ListTrackerConsumersRequest
import aws.sdk.kotlin.services.location.model.ListTrackerConsumersResponse
import aws.sdk.kotlin.services.location.model.ListTrackersRequest
import aws.sdk.kotlin.services.location.model.ListTrackersResponse
import aws.sdk.kotlin.services.location.model.ListTrackersResponseEntry
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ForecastGeofenceEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ForecastGeofenceEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ForecastGeofenceEventsResponse]
 */
public fun LocationClient.forecastGeofenceEventsPaginated(initialRequest: ForecastGeofenceEventsRequest): Flow<ForecastGeofenceEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@forecastGeofenceEventsPaginated.forecastGeofenceEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ForecastGeofenceEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ForecastGeofenceEventsResponse]
 */
public fun LocationClient.forecastGeofenceEventsPaginated(block: ForecastGeofenceEventsRequest.Builder.() -> Unit): Flow<ForecastGeofenceEventsResponse> =
    forecastGeofenceEventsPaginated(ForecastGeofenceEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [forecastGeofenceEventsPaginated]
 * to access the nested member [ForecastedEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ForecastedEvent]
 */
@JvmName("forecastGeofenceEventsResponseForecastedEvent")
public fun Flow<ForecastGeofenceEventsResponse>.forecastedEvents(): Flow<ForecastedEvent> =
    transform() { response ->
        response.forecastedEvents?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetDevicePositionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetDevicePositionHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDevicePositionHistoryResponse]
 */
public fun LocationClient.getDevicePositionHistoryPaginated(initialRequest: GetDevicePositionHistoryRequest): Flow<GetDevicePositionHistoryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getDevicePositionHistoryPaginated.getDevicePositionHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetDevicePositionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDevicePositionHistoryResponse]
 */
public fun LocationClient.getDevicePositionHistoryPaginated(block: GetDevicePositionHistoryRequest.Builder.() -> Unit): Flow<GetDevicePositionHistoryResponse> =
    getDevicePositionHistoryPaginated(GetDevicePositionHistoryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getDevicePositionHistoryPaginated]
 * to access the nested member [DevicePosition]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DevicePosition]
 */
@JvmName("getDevicePositionHistoryResponseDevicePosition")
public fun Flow<GetDevicePositionHistoryResponse>.devicePositions(): Flow<DevicePosition> =
    transform() { response ->
        response.devicePositions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDevicePositionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDevicePositionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevicePositionsResponse]
 */
public fun LocationClient.listDevicePositionsPaginated(initialRequest: ListDevicePositionsRequest): Flow<ListDevicePositionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDevicePositionsPaginated.listDevicePositions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDevicePositionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevicePositionsResponse]
 */
public fun LocationClient.listDevicePositionsPaginated(block: ListDevicePositionsRequest.Builder.() -> Unit): Flow<ListDevicePositionsResponse> =
    listDevicePositionsPaginated(ListDevicePositionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDevicePositionsPaginated]
 * to access the nested member [ListDevicePositionsResponseEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevicePositionsResponseEntry]
 */
@JvmName("listDevicePositionsResponseListDevicePositionsResponseEntry")
public fun Flow<ListDevicePositionsResponse>.entries(): Flow<ListDevicePositionsResponseEntry> =
    transform() { response ->
        response.entries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGeofenceCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGeofenceCollectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeofenceCollectionsResponse]
 */
public fun LocationClient.listGeofenceCollectionsPaginated(initialRequest: ListGeofenceCollectionsRequest = ListGeofenceCollectionsRequest { }): Flow<ListGeofenceCollectionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGeofenceCollectionsPaginated.listGeofenceCollections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGeofenceCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeofenceCollectionsResponse]
 */
public fun LocationClient.listGeofenceCollectionsPaginated(block: ListGeofenceCollectionsRequest.Builder.() -> Unit): Flow<ListGeofenceCollectionsResponse> =
    listGeofenceCollectionsPaginated(ListGeofenceCollectionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGeofenceCollectionsPaginated]
 * to access the nested member [ListGeofenceCollectionsResponseEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeofenceCollectionsResponseEntry]
 */
@JvmName("listGeofenceCollectionsResponseListGeofenceCollectionsResponseEntry")
public fun Flow<ListGeofenceCollectionsResponse>.entries(): Flow<ListGeofenceCollectionsResponseEntry> =
    transform() { response ->
        response.entries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGeofencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGeofencesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeofencesResponse]
 */
public fun LocationClient.listGeofencesPaginated(initialRequest: ListGeofencesRequest): Flow<ListGeofencesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGeofencesPaginated.listGeofences(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGeofencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeofencesResponse]
 */
public fun LocationClient.listGeofencesPaginated(block: ListGeofencesRequest.Builder.() -> Unit): Flow<ListGeofencesResponse> =
    listGeofencesPaginated(ListGeofencesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGeofencesPaginated]
 * to access the nested member [ListGeofenceResponseEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeofenceResponseEntry]
 */
@JvmName("listGeofencesResponseListGeofenceResponseEntry")
public fun Flow<ListGeofencesResponse>.entries(): Flow<ListGeofenceResponseEntry> =
    transform() { response ->
        response.entries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeysResponse]
 */
public fun LocationClient.listKeysPaginated(initialRequest: ListKeysRequest = ListKeysRequest { }): Flow<ListKeysResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKeysPaginated.listKeys(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeysResponse]
 */
public fun LocationClient.listKeysPaginated(block: ListKeysRequest.Builder.() -> Unit): Flow<ListKeysResponse> =
    listKeysPaginated(ListKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listKeysPaginated]
 * to access the nested member [ListKeysResponseEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeysResponseEntry]
 */
@JvmName("listKeysResponseListKeysResponseEntry")
public fun Flow<ListKeysResponse>.entries(): Flow<ListKeysResponseEntry> =
    transform() { response ->
        response.entries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMapsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMapsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMapsResponse]
 */
public fun LocationClient.listMapsPaginated(initialRequest: ListMapsRequest = ListMapsRequest { }): Flow<ListMapsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMapsPaginated.listMaps(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMapsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMapsResponse]
 */
public fun LocationClient.listMapsPaginated(block: ListMapsRequest.Builder.() -> Unit): Flow<ListMapsResponse> =
    listMapsPaginated(ListMapsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMapsPaginated]
 * to access the nested member [ListMapsResponseEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMapsResponseEntry]
 */
@JvmName("listMapsResponseListMapsResponseEntry")
public fun Flow<ListMapsResponse>.entries(): Flow<ListMapsResponseEntry> =
    transform() { response ->
        response.entries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPlaceIndexesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPlaceIndexesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlaceIndexesResponse]
 */
public fun LocationClient.listPlaceIndexesPaginated(initialRequest: ListPlaceIndexesRequest = ListPlaceIndexesRequest { }): Flow<ListPlaceIndexesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPlaceIndexesPaginated.listPlaceIndexes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPlaceIndexesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlaceIndexesResponse]
 */
public fun LocationClient.listPlaceIndexesPaginated(block: ListPlaceIndexesRequest.Builder.() -> Unit): Flow<ListPlaceIndexesResponse> =
    listPlaceIndexesPaginated(ListPlaceIndexesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPlaceIndexesPaginated]
 * to access the nested member [ListPlaceIndexesResponseEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlaceIndexesResponseEntry]
 */
@JvmName("listPlaceIndexesResponseListPlaceIndexesResponseEntry")
public fun Flow<ListPlaceIndexesResponse>.entries(): Flow<ListPlaceIndexesResponseEntry> =
    transform() { response ->
        response.entries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRouteCalculatorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRouteCalculatorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRouteCalculatorsResponse]
 */
public fun LocationClient.listRouteCalculatorsPaginated(initialRequest: ListRouteCalculatorsRequest = ListRouteCalculatorsRequest { }): Flow<ListRouteCalculatorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRouteCalculatorsPaginated.listRouteCalculators(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRouteCalculatorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRouteCalculatorsResponse]
 */
public fun LocationClient.listRouteCalculatorsPaginated(block: ListRouteCalculatorsRequest.Builder.() -> Unit): Flow<ListRouteCalculatorsResponse> =
    listRouteCalculatorsPaginated(ListRouteCalculatorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRouteCalculatorsPaginated]
 * to access the nested member [ListRouteCalculatorsResponseEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRouteCalculatorsResponseEntry]
 */
@JvmName("listRouteCalculatorsResponseListRouteCalculatorsResponseEntry")
public fun Flow<ListRouteCalculatorsResponse>.entries(): Flow<ListRouteCalculatorsResponseEntry> =
    transform() { response ->
        response.entries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTrackerConsumersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrackerConsumersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrackerConsumersResponse]
 */
public fun LocationClient.listTrackerConsumersPaginated(initialRequest: ListTrackerConsumersRequest): Flow<ListTrackerConsumersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrackerConsumersPaginated.listTrackerConsumers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTrackerConsumersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrackerConsumersResponse]
 */
public fun LocationClient.listTrackerConsumersPaginated(block: ListTrackerConsumersRequest.Builder.() -> Unit): Flow<ListTrackerConsumersResponse> =
    listTrackerConsumersPaginated(ListTrackerConsumersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTrackerConsumersPaginated]
 * to access the nested member [Arn]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Arn]
 */
@JvmName("listTrackerConsumersResponseArn")
public fun Flow<ListTrackerConsumersResponse>.consumerArns(): Flow<String> =
    transform() { response ->
        response.consumerArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTrackersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrackersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrackersResponse]
 */
public fun LocationClient.listTrackersPaginated(initialRequest: ListTrackersRequest = ListTrackersRequest { }): Flow<ListTrackersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrackersPaginated.listTrackers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTrackersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrackersResponse]
 */
public fun LocationClient.listTrackersPaginated(block: ListTrackersRequest.Builder.() -> Unit): Flow<ListTrackersResponse> =
    listTrackersPaginated(ListTrackersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTrackersPaginated]
 * to access the nested member [ListTrackersResponseEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrackersResponseEntry]
 */
@JvmName("listTrackersResponseListTrackersResponseEntry")
public fun Flow<ListTrackersResponse>.entries(): Flow<ListTrackersResponseEntry> =
    transform() { response ->
        response.entries?.forEach {
            emit(it)
        }
    }
