// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * A summary of the request sent by using `SearchPlaceIndexForText`.
 */
public class SearchPlaceIndexForTextSummary private constructor(builder: Builder) {
    /**
     * Contains the coordinates for the optional bias position specified in the request.
     *
     * This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.
     *
     * For example, `[-123.1174, 49.2847]` represents the position with longitude `-123.1174` and latitude `49.2847`.
     */
    public val biasPosition: List<Double>? = builder.biasPosition
    /**
     * The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:
     * + Esri
     * + Grab
     * + Here
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String = requireNotNull(builder.dataSource) { "A non-null value must be provided for dataSource" }
    /**
     * Contains the coordinates for the optional bounding box specified in the request.
     */
    public val filterBBox: List<Double>? = builder.filterBBox
    /**
     * The optional category filter specified in the request.
     */
    public val filterCategories: List<String>? = builder.filterCategories
    /**
     * Contains the optional country filter specified in the request.
     */
    public val filterCountries: List<String>? = builder.filterCountries
    /**
     * The preferred language used to return results. Matches the language in the request. The value is a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
     */
    public val language: kotlin.String? = builder.language
    /**
     * Contains the optional result count limit specified in the request.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The bounding box that fully contains all search results.
     *
     * If you specified the optional `FilterBBox` parameter in the request, `ResultBBox` is contained within `FilterBBox`.
     */
    public val resultBBox: List<Double>? = builder.resultBBox
    /**
     * The search text specified in the request.
     */
    public val text: kotlin.String = requireNotNull(builder.text) { "A non-null value must be provided for text" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchPlaceIndexForTextSummary(")
        append("biasPosition=*** Sensitive Data Redacted ***,")
        append("dataSource=$dataSource,")
        append("filterBBox=*** Sensitive Data Redacted ***,")
        append("filterCategories=*** Sensitive Data Redacted ***,")
        append("filterCountries=*** Sensitive Data Redacted ***,")
        append("language=$language,")
        append("maxResults=$maxResults,")
        append("resultBBox=*** Sensitive Data Redacted ***,")
        append("text=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = biasPosition?.hashCode() ?: 0
        result = 31 * result + (this.dataSource.hashCode())
        result = 31 * result + (this.filterBBox?.hashCode() ?: 0)
        result = 31 * result + (this.filterCategories?.hashCode() ?: 0)
        result = 31 * result + (this.filterCountries?.hashCode() ?: 0)
        result = 31 * result + (this.language?.hashCode() ?: 0)
        result = 31 * result + (this.maxResults ?: 0)
        result = 31 * result + (this.resultBBox?.hashCode() ?: 0)
        result = 31 * result + (this.text.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchPlaceIndexForTextSummary

        if (biasPosition != other.biasPosition) return false
        if (dataSource != other.dataSource) return false
        if (filterBBox != other.filterBBox) return false
        if (filterCategories != other.filterCategories) return false
        if (filterCountries != other.filterCountries) return false
        if (language != other.language) return false
        if (maxResults != other.maxResults) return false
        if (resultBBox != other.resultBBox) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains the coordinates for the optional bias position specified in the request.
         *
         * This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.
         *
         * For example, `[-123.1174, 49.2847]` represents the position with longitude `-123.1174` and latitude `49.2847`.
         */
        public var biasPosition: List<Double>? = null
        /**
         * The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:
         * + Esri
         * + Grab
         * + Here
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * Contains the coordinates for the optional bounding box specified in the request.
         */
        public var filterBBox: List<Double>? = null
        /**
         * The optional category filter specified in the request.
         */
        public var filterCategories: List<String>? = null
        /**
         * Contains the optional country filter specified in the request.
         */
        public var filterCountries: List<String>? = null
        /**
         * The preferred language used to return results. Matches the language in the request. The value is a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
         */
        public var language: kotlin.String? = null
        /**
         * Contains the optional result count limit specified in the request.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The bounding box that fully contains all search results.
         *
         * If you specified the optional `FilterBBox` parameter in the request, `ResultBBox` is contained within `FilterBBox`.
         */
        public var resultBBox: List<Double>? = null
        /**
         * The search text specified in the request.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextSummary) : this() {
            this.biasPosition = x.biasPosition
            this.dataSource = x.dataSource
            this.filterBBox = x.filterBBox
            this.filterCategories = x.filterCategories
            this.filterCountries = x.filterCountries
            this.language = x.language
            this.maxResults = x.maxResults
            this.resultBBox = x.resultBBox
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextSummary = SearchPlaceIndexForTextSummary(this)

        internal fun correctErrors(): Builder {
            if (dataSource == null) dataSource = ""
            if (text == null) text = ""
            return this
        }
    }
}
