// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


/**
 * Contains the tracker resource details.
 */
public class ListTrackersResponseEntry private constructor(builder: Builder) {
    /**
     * The timestamp for when the tracker resource was created in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description for the tracker resource.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The name of the tracker resource.
     */
    public val trackerName: kotlin.String = requireNotNull(builder.trackerName) { "A non-null value must be provided for trackerName" }
    /**
     * The timestamp at which the device's position was determined. Uses [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ListTrackersResponseEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTrackersResponseEntry(")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("description=$description,")
        append("trackerName=$trackerName,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (this.description.hashCode())
        result = 31 * result + (this.trackerName.hashCode())
        result = 31 * result + (this.updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTrackersResponseEntry

        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (trackerName != other.trackerName) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ListTrackersResponseEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp for when the tracker resource was created in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the tracker resource.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the tracker resource.
         */
        public var trackerName: kotlin.String? = null
        /**
         * The timestamp at which the device's position was determined. Uses [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ListTrackersResponseEntry) : this() {
            this.createTime = x.createTime
            this.description = x.description
            this.trackerName = x.trackerName
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ListTrackersResponseEntry = ListTrackersResponseEntry(this)

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (trackerName == null) trackerName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
