// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

private val awsSdkKotlinServicesLocationModelApiKeyRestrictionsDslBuilderRef = aws.sdk.kotlin.services.location.model.ApiKeyRestrictions

/**
 * An API key resource listed in your Amazon Web Services account.
 */
public class ListKeysResponseEntry private constructor(builder: Builder) {
    /**
     * The timestamp of when the API key was created, in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The optional description for the API key resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The timestamp for when the API key resource will expire, in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val expireTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.expireTime) { "A non-null value must be provided for expireTime" }
    /**
     * The name of the API key resource.
     */
    public val keyName: kotlin.String = requireNotNull(builder.keyName) { "A non-null value must be provided for keyName" }
    /**
     * API Restrictions on the allowed actions, resources, and referers for an API key resource.
     */
    public val restrictions: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions? = builder.restrictions
    /**
     * The timestamp of when the API key was last updated, in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ListKeysResponseEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListKeysResponseEntry(")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("description=$description,")
        append("expireTime=*** Sensitive Data Redacted ***,")
        append("keyName=$keyName,")
        append("restrictions=$restrictions,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (this.description?.hashCode() ?: 0)
        result = 31 * result + (this.expireTime.hashCode())
        result = 31 * result + (this.keyName.hashCode())
        result = 31 * result + (this.restrictions?.hashCode() ?: 0)
        result = 31 * result + (this.updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListKeysResponseEntry

        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (expireTime != other.expireTime) return false
        if (keyName != other.keyName) return false
        if (restrictions != other.restrictions) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ListKeysResponseEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the API key was created, in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional description for the API key resource.
         */
        public var description: kotlin.String? = null
        /**
         * The timestamp for when the API key resource will expire, in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var expireTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the API key resource.
         */
        public var keyName: kotlin.String? = null
        /**
         * API Restrictions on the allowed actions, resources, and referers for an API key resource.
         */
        public var restrictions: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions? = null
        /**
         * The timestamp of when the API key was last updated, in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ListKeysResponseEntry) : this() {
            this.createTime = x.createTime
            this.description = x.description
            this.expireTime = x.expireTime
            this.keyName = x.keyName
            this.restrictions = x.restrictions
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ListKeysResponseEntry = ListKeysResponseEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.ApiKeyRestrictions] inside the given [block]
         */
        public fun restrictions(block: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions.Builder.() -> kotlin.Unit) {
            this.restrictions = awsSdkKotlinServicesLocationModelApiKeyRestrictionsDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (expireTime == null) expireTime = Instant.fromEpochSeconds(0)
            if (keyName == null) keyName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
