// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


public class ListGeofencesRequest private constructor(builder: Builder) {
    /**
     * The name of the geofence collection storing the list of geofences.
     */
    public val collectionName: kotlin.String = requireNotNull(builder.collectionName) { "A non-null value must be provided for collectionName" }
    /**
     * An optional limit for the number of geofences returned in a single call.
     *
     * Default value: `100`
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.
     *
     * Default value: `null`
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ListGeofencesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGeofencesRequest(")
        append("collectionName=$collectionName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionName.hashCode()
        result = 31 * result + (this.maxResults ?: 0)
        result = 31 * result + (this.nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGeofencesRequest

        if (collectionName != other.collectionName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ListGeofencesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the geofence collection storing the list of geofences.
         */
        public var collectionName: kotlin.String? = null
        /**
         * An optional limit for the number of geofences returned in a single call.
         *
         * Default value: `100`
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.
         *
         * Default value: `null`
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ListGeofencesRequest) : this() {
            this.collectionName = x.collectionName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ListGeofencesRequest = ListGeofencesRequest(this)

        internal fun correctErrors(): Builder {
            if (collectionName == null) collectionName = ""
            return this
        }
    }
}
