// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

private val awsSdkKotlinServicesLocationModelGeofenceGeometryDslBuilderRef = aws.sdk.kotlin.services.location.model.GeofenceGeometry

public class GetGeofenceResponse private constructor(builder: Builder) {
    /**
     * The timestamp for when the geofence collection was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The geofence identifier.
     */
    public val geofenceId: kotlin.String = requireNotNull(builder.geofenceId) { "A non-null value must be provided for geofenceId" }
    /**
     * User defined properties of the geofence. A property is a key-value pair stored with the geofence and added to any geofence event triggered with that geofence.
     *
     * Format: `"key" : "value"`
     */
    public val geofenceProperties: Map<String, String>? = builder.geofenceProperties
    /**
     * Contains the geofence geometry details describing the position of the geofence. Can be a circle, a polygon, or a multipolygon.
     */
    public val geometry: aws.sdk.kotlin.services.location.model.GeofenceGeometry? = builder.geometry
    /**
     * Identifies the state of the geofence. A geofence will hold one of the following states:
     * + `ACTIVE` — The geofence has been indexed by the system.
     * + `PENDING` — The geofence is being processed by the system.
     * + `FAILED` — The geofence failed to be indexed by the system.
     * + `DELETED` — The geofence has been deleted from the system index.
     * + `DELETING` — The geofence is being deleted from the system index.
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The timestamp for when the geofence collection was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.GetGeofenceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetGeofenceResponse(")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("geofenceId=$geofenceId,")
        append("geofenceProperties=*** Sensitive Data Redacted ***,")
        append("geometry=$geometry,")
        append("status=$status,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (this.geofenceId.hashCode())
        result = 31 * result + (this.geofenceProperties?.hashCode() ?: 0)
        result = 31 * result + (this.geometry?.hashCode() ?: 0)
        result = 31 * result + (this.status.hashCode())
        result = 31 * result + (this.updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetGeofenceResponse

        if (createTime != other.createTime) return false
        if (geofenceId != other.geofenceId) return false
        if (geofenceProperties != other.geofenceProperties) return false
        if (geometry != other.geometry) return false
        if (status != other.status) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.GetGeofenceResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp for when the geofence collection was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The geofence identifier.
         */
        public var geofenceId: kotlin.String? = null
        /**
         * User defined properties of the geofence. A property is a key-value pair stored with the geofence and added to any geofence event triggered with that geofence.
         *
         * Format: `"key" : "value"`
         */
        public var geofenceProperties: Map<String, String>? = null
        /**
         * Contains the geofence geometry details describing the position of the geofence. Can be a circle, a polygon, or a multipolygon.
         */
        public var geometry: aws.sdk.kotlin.services.location.model.GeofenceGeometry? = null
        /**
         * Identifies the state of the geofence. A geofence will hold one of the following states:
         * + `ACTIVE` — The geofence has been indexed by the system.
         * + `PENDING` — The geofence is being processed by the system.
         * + `FAILED` — The geofence failed to be indexed by the system.
         * + `DELETED` — The geofence has been deleted from the system index.
         * + `DELETING` — The geofence is being deleted from the system index.
         */
        public var status: kotlin.String? = null
        /**
         * The timestamp for when the geofence collection was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.GetGeofenceResponse) : this() {
            this.createTime = x.createTime
            this.geofenceId = x.geofenceId
            this.geofenceProperties = x.geofenceProperties
            this.geometry = x.geometry
            this.status = x.status
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.GetGeofenceResponse = GetGeofenceResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.GeofenceGeometry] inside the given [block]
         */
        public fun geometry(block: aws.sdk.kotlin.services.location.model.GeofenceGeometry.Builder.() -> kotlin.Unit) {
            this.geometry = awsSdkKotlinServicesLocationModelGeofenceGeometryDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (geofenceId == null) geofenceId = ""
            if (status == null) status = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
