// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesLocationModelCircleDslBuilderRef = aws.sdk.kotlin.services.location.model.Circle

/**
 * Contains the geofence geometry details.
 *
 * A geofence geometry can be a circle, a polygon, or a multipolygon. `Polygon` and `MultiPolygon` geometries can be defined using their respective parameters, or encoded in Geobuf format using the `Geobuf` parameter. Including multiple geometry types in the same request will return a validation error.
 *
 * Amazon Location doesn't currently support polygons that cross the antimeridian.
 */
public class GeofenceGeometry private constructor(builder: Builder) {
    /**
     * A circle on the earth, as defined by a center point and a radius.
     */
    public val circle: aws.sdk.kotlin.services.location.model.Circle? = builder.circle
    /**
     * Geobuf is a compact binary encoding for geographic data that provides lossless compression of GeoJSON polygons. The Geobuf must be Base64-encoded.
     *
     * This parameter can contain a Geobuf-encoded GeoJSON geometry object of type `Polygon`*OR*`MultiPolygon`. For more information and specific configuration requirements for these object types, see [Polygon](https://docs.aws.amazon.com/location/latest/APIReference/API_WaypointGeofencing_GeofenceGeometry.html#location-Type-WaypointGeofencing_GeofenceGeometry-Polygon) and [MultiPolygon](https://docs.aws.amazon.com/location/latest/APIReference/API_WaypointGeofencing_GeofenceGeometry.html#location-Type-WaypointGeofencing_GeofenceGeometry-MultiPolygon).
     *
     * The following limitations apply specifically to geometries defined using the `Geobuf` parameter, and supercede the corresponding limitations of the `Polygon` and `MultiPolygon` parameters:
     * + A `Polygon` in `Geobuf` format can have up to 25,000 rings and up to 100,000 total vertices, including all vertices from all component rings.
     * + A `MultiPolygon` in `Geobuf` format can contain up to 10,000 `Polygons` and up to 100,000 total vertices, including all vertices from all component `Polygons`.
     */
    public val geobuf: kotlin.ByteArray? = builder.geobuf
    /**
     * A `MultiPolygon` is a list of up to 250 `Polygon` elements which represent the shape of a geofence. The `Polygon` components of a `MultiPolygon` geometry can define separate geographical areas that are considered part of the same geofence, perimeters of larger exterior areas with smaller interior spaces that are excluded from the geofence, or some combination of these use cases to form complex geofence boundaries.
     *
     * For more information and specific configuration requirements for the `Polygon` components that form a `MultiPolygon`, see [Polygon](https://docs.aws.amazon.com/location/latest/APIReference/API_WaypointGeofencing_GeofenceGeometry.html#location-Type-WaypointGeofencing_GeofenceGeometry-Polygon).
     *
     * The following additional requirements and limitations apply to geometries defined using the `MultiPolygon` parameter:
     * + The entire `MultiPolygon` must consist of no more than 1,000 vertices, including all vertices from all component `Polygons`.
     * + Each edge of a component `Polygon` must intersect no more than 5 edges from other `Polygons`. Parallel edges that are shared but do not cross are not counted toward this limit.
     * + The total number of intersecting edges of component `Polygons` must be no more than 100,000. Parallel edges that are shared but do not cross are not counted toward this limit.
     */
    public val multiPolygon: List<List<List<List<Double>>>>? = builder.multiPolygon
    /**
     * A `Polygon` is a list of up to 250 linear rings which represent the shape of a geofence. This list *must* include 1 exterior ring (representing the outer perimeter of the geofence), and can optionally include up to 249 interior rings (representing polygonal spaces within the perimeter, which are excluded from the geofence area).
     *
     * A linear ring is an array of 4 or more vertices, where the first and last vertex are the same (to form a closed boundary). Each vertex is a 2-dimensional point represented as an array of doubles of length 2: `[longitude, latitude]`.
     *
     * Each linear ring is represented as an array of arrays of doubles (`[[longitude, latitude], [longitude, latitude], ...]`). The vertices for the exterior ring must be listed in *counter-clockwise* sequence. Vertices for all interior rings must be listed in *clockwise* sequence.
     *
     * The list of linear rings that describe the entire `Polygon` is represented as an array of arrays of arrays of doubles (`[[[longitude, latitude], [longitude, latitude], ...], [[longitude, latitude], [longitude, latitude], ...], ...]`). The exterior ring must be listed first, before any interior rings.
     *
     * The following additional requirements and limitations apply to geometries defined using the `Polygon` parameter:
     * + The entire `Polygon` must consist of no more than 1,000 vertices, including all vertices from the exterior ring and all interior rings.
     * + Rings must not touch or cross each other.
     * + All interior rings must be fully contained within the exterior ring.
     * + Interior rings must not contain other interior rings.
     * + No ring is permitted to intersect itself.
     */
    public val polygon: List<List<List<Double>>>? = builder.polygon

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.GeofenceGeometry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeofenceGeometry(")
        append("circle=*** Sensitive Data Redacted ***,")
        append("geobuf=*** Sensitive Data Redacted ***,")
        append("multiPolygon=*** Sensitive Data Redacted ***,")
        append("polygon=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = circle?.hashCode() ?: 0
        result = 31 * result + (this.geobuf?.contentHashCode() ?: 0)
        result = 31 * result + (this.multiPolygon?.hashCode() ?: 0)
        result = 31 * result + (this.polygon?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeofenceGeometry

        if (circle != other.circle) return false
        if (geobuf != null) {
            if (other.geobuf == null) return false
            if (!geobuf.contentEquals(other.geobuf)) return false
        } else if (other.geobuf != null) return false
        if (multiPolygon != other.multiPolygon) return false
        if (polygon != other.polygon) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.GeofenceGeometry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A circle on the earth, as defined by a center point and a radius.
         */
        public var circle: aws.sdk.kotlin.services.location.model.Circle? = null
        /**
         * Geobuf is a compact binary encoding for geographic data that provides lossless compression of GeoJSON polygons. The Geobuf must be Base64-encoded.
         *
         * This parameter can contain a Geobuf-encoded GeoJSON geometry object of type `Polygon`*OR*`MultiPolygon`. For more information and specific configuration requirements for these object types, see [Polygon](https://docs.aws.amazon.com/location/latest/APIReference/API_WaypointGeofencing_GeofenceGeometry.html#location-Type-WaypointGeofencing_GeofenceGeometry-Polygon) and [MultiPolygon](https://docs.aws.amazon.com/location/latest/APIReference/API_WaypointGeofencing_GeofenceGeometry.html#location-Type-WaypointGeofencing_GeofenceGeometry-MultiPolygon).
         *
         * The following limitations apply specifically to geometries defined using the `Geobuf` parameter, and supercede the corresponding limitations of the `Polygon` and `MultiPolygon` parameters:
         * + A `Polygon` in `Geobuf` format can have up to 25,000 rings and up to 100,000 total vertices, including all vertices from all component rings.
         * + A `MultiPolygon` in `Geobuf` format can contain up to 10,000 `Polygons` and up to 100,000 total vertices, including all vertices from all component `Polygons`.
         */
        public var geobuf: kotlin.ByteArray? = null
        /**
         * A `MultiPolygon` is a list of up to 250 `Polygon` elements which represent the shape of a geofence. The `Polygon` components of a `MultiPolygon` geometry can define separate geographical areas that are considered part of the same geofence, perimeters of larger exterior areas with smaller interior spaces that are excluded from the geofence, or some combination of these use cases to form complex geofence boundaries.
         *
         * For more information and specific configuration requirements for the `Polygon` components that form a `MultiPolygon`, see [Polygon](https://docs.aws.amazon.com/location/latest/APIReference/API_WaypointGeofencing_GeofenceGeometry.html#location-Type-WaypointGeofencing_GeofenceGeometry-Polygon).
         *
         * The following additional requirements and limitations apply to geometries defined using the `MultiPolygon` parameter:
         * + The entire `MultiPolygon` must consist of no more than 1,000 vertices, including all vertices from all component `Polygons`.
         * + Each edge of a component `Polygon` must intersect no more than 5 edges from other `Polygons`. Parallel edges that are shared but do not cross are not counted toward this limit.
         * + The total number of intersecting edges of component `Polygons` must be no more than 100,000. Parallel edges that are shared but do not cross are not counted toward this limit.
         */
        public var multiPolygon: List<List<List<List<Double>>>>? = null
        /**
         * A `Polygon` is a list of up to 250 linear rings which represent the shape of a geofence. This list *must* include 1 exterior ring (representing the outer perimeter of the geofence), and can optionally include up to 249 interior rings (representing polygonal spaces within the perimeter, which are excluded from the geofence area).
         *
         * A linear ring is an array of 4 or more vertices, where the first and last vertex are the same (to form a closed boundary). Each vertex is a 2-dimensional point represented as an array of doubles of length 2: `[longitude, latitude]`.
         *
         * Each linear ring is represented as an array of arrays of doubles (`[[longitude, latitude], [longitude, latitude], ...]`). The vertices for the exterior ring must be listed in *counter-clockwise* sequence. Vertices for all interior rings must be listed in *clockwise* sequence.
         *
         * The list of linear rings that describe the entire `Polygon` is represented as an array of arrays of arrays of doubles (`[[[longitude, latitude], [longitude, latitude], ...], [[longitude, latitude], [longitude, latitude], ...], ...]`). The exterior ring must be listed first, before any interior rings.
         *
         * The following additional requirements and limitations apply to geometries defined using the `Polygon` parameter:
         * + The entire `Polygon` must consist of no more than 1,000 vertices, including all vertices from the exterior ring and all interior rings.
         * + Rings must not touch or cross each other.
         * + All interior rings must be fully contained within the exterior ring.
         * + Interior rings must not contain other interior rings.
         * + No ring is permitted to intersect itself.
         */
        public var polygon: List<List<List<Double>>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.GeofenceGeometry) : this() {
            this.circle = x.circle
            this.geobuf = x.geobuf
            this.multiPolygon = x.multiPolygon
            this.polygon = x.polygon
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.GeofenceGeometry = GeofenceGeometry(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.Circle] inside the given [block]
         */
        public fun circle(block: aws.sdk.kotlin.services.location.model.Circle.Builder.() -> kotlin.Unit) {
            this.circle = awsSdkKotlinServicesLocationModelCircleDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
