// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


public class DescribeGeofenceCollectionResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection`
     */
    public val collectionArn: kotlin.String = requireNotNull(builder.collectionArn) { "A non-null value must be provided for collectionArn" }
    /**
     * The name of the geofence collection.
     */
    public val collectionName: kotlin.String = requireNotNull(builder.collectionName) { "A non-null value must be provided for collectionName" }
    /**
     * The timestamp for when the geofence resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The optional description for the geofence collection.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The number of geofences in the geofence collection.
     */
    public val geofenceCount: kotlin.Int? = builder.geofenceCount
    /**
     * A key identifier for an [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) assigned to the Amazon Location resource
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Displays the key, value pairs of tags associated with this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timestamp for when the geofence collection was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGeofenceCollectionResponse(")
        append("collectionArn=$collectionArn,")
        append("collectionName=$collectionName,")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("description=$description,")
        append("geofenceCount=$geofenceCount,")
        append("kmsKeyId=$kmsKeyId,")
        append("tags=$tags,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionArn.hashCode()
        result = 31 * result + (this.collectionName.hashCode())
        result = 31 * result + (this.createTime.hashCode())
        result = 31 * result + (this.description.hashCode())
        result = 31 * result + (this.geofenceCount ?: 0)
        result = 31 * result + (this.kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        result = 31 * result + (this.updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeGeofenceCollectionResponse

        if (collectionArn != other.collectionArn) return false
        if (collectionName != other.collectionName) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (geofenceCount != other.geofenceCount) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection`
         */
        public var collectionArn: kotlin.String? = null
        /**
         * The name of the geofence collection.
         */
        public var collectionName: kotlin.String? = null
        /**
         * The timestamp for when the geofence resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional description for the geofence collection.
         */
        public var description: kotlin.String? = null
        /**
         * The number of geofences in the geofence collection.
         */
        public var geofenceCount: kotlin.Int? = null
        /**
         * A key identifier for an [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) assigned to the Amazon Location resource
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Displays the key, value pairs of tags associated with this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timestamp for when the geofence collection was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse) : this() {
            this.collectionArn = x.collectionArn
            this.collectionName = x.collectionName
            this.createTime = x.createTime
            this.description = x.description
            this.geofenceCount = x.geofenceCount
            this.kmsKeyId = x.kmsKeyId
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse = DescribeGeofenceCollectionResponse(this)

        internal fun correctErrors(): Builder {
            if (collectionArn == null) collectionArn = ""
            if (collectionName == null) collectionName = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
