// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


public class CreateTrackerRequest private constructor(builder: Builder) {
    /**
     * An optional description for the tracker resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Whether to enable position `UPDATE` events from this tracker to be sent to EventBridge.
     *
     * You do not need enable this feature to get `ENTER` and `EXIT` events for geofences with this tracker. Those events are always sent to EventBridge.
     */
    public val eventBridgeEnabled: kotlin.Boolean? = builder.eventBridgeEnabled
    /**
     * Enables `GeospatialQueries` for a tracker that uses a [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
     *
     * This parameter is only used if you are using a KMS customer managed key.
     *
     * If you wish to encrypt your data using your own KMS customer managed key, then the Bounding Polygon Queries feature will be disabled by default. This is because by using this feature, a representation of your device positions will not be encrypted using the your KMS managed key. The exact device position, however; is still encrypted using your managed key.
     *
     * You can choose to opt-in to the Bounding Polygon Quseries feature. This is done by setting the `KmsKeyEnableGeospatialQueries` parameter to true when creating or updating a Tracker.
     */
    public val kmsKeyEnableGeospatialQueries: kotlin.Boolean? = builder.kmsKeyEnableGeospatialQueries
    /**
     * A key identifier for an [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html). Enter a key ID, key ARN, alias name, or alias ARN.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the position filtering for the tracker resource.
     *
     * Valid values:
     * + `TimeBased` - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.
     * + `DistanceBased` - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.
     * + `AccuracyBased` - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations.
     *
     * This field is optional. If not specified, the default value is `TimeBased`.
     */
    public val positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = builder.positionFiltering
    /**
     * Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
     *
     * Format: `"key" : "value"`
     *
     * Restrictions:
     * + Maximum 50 tags per resource
     * + Each resource tag must be unique with a maximum of one value.
     * + Maximum key length: 128 Unicode characters in UTF-8
     * + Maximum value length: 256 Unicode characters in UTF-8
     * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     * + Cannot use "aws:" as a prefix for a key.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The name for the tracker resource.
     *
     * Requirements:
     * + Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     * + Must be a unique tracker resource name.
     * + No spaces allowed. For example, `ExampleTracker`.
     */
    public val trackerName: kotlin.String = requireNotNull(builder.trackerName) { "A non-null value must be provided for trackerName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateTrackerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrackerRequest(")
        append("description=$description,")
        append("eventBridgeEnabled=$eventBridgeEnabled,")
        append("kmsKeyEnableGeospatialQueries=$kmsKeyEnableGeospatialQueries,")
        append("kmsKeyId=$kmsKeyId,")
        append("positionFiltering=$positionFiltering,")
        append("tags=$tags,")
        append("trackerName=$trackerName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (this.eventBridgeEnabled?.hashCode() ?: 0)
        result = 31 * result + (this.kmsKeyEnableGeospatialQueries?.hashCode() ?: 0)
        result = 31 * result + (this.kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (this.positionFiltering?.hashCode() ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        result = 31 * result + (this.trackerName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrackerRequest

        if (description != other.description) return false
        if (eventBridgeEnabled != other.eventBridgeEnabled) return false
        if (kmsKeyEnableGeospatialQueries != other.kmsKeyEnableGeospatialQueries) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (positionFiltering != other.positionFiltering) return false
        if (tags != other.tags) return false
        if (trackerName != other.trackerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateTrackerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional description for the tracker resource.
         */
        public var description: kotlin.String? = null
        /**
         * Whether to enable position `UPDATE` events from this tracker to be sent to EventBridge.
         *
         * You do not need enable this feature to get `ENTER` and `EXIT` events for geofences with this tracker. Those events are always sent to EventBridge.
         */
        public var eventBridgeEnabled: kotlin.Boolean? = null
        /**
         * Enables `GeospatialQueries` for a tracker that uses a [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
         *
         * This parameter is only used if you are using a KMS customer managed key.
         *
         * If you wish to encrypt your data using your own KMS customer managed key, then the Bounding Polygon Queries feature will be disabled by default. This is because by using this feature, a representation of your device positions will not be encrypted using the your KMS managed key. The exact device position, however; is still encrypted using your managed key.
         *
         * You can choose to opt-in to the Bounding Polygon Quseries feature. This is done by setting the `KmsKeyEnableGeospatialQueries` parameter to true when creating or updating a Tracker.
         */
        public var kmsKeyEnableGeospatialQueries: kotlin.Boolean? = null
        /**
         * A key identifier for an [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html). Enter a key ID, key ARN, alias name, or alias ARN.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the position filtering for the tracker resource.
         *
         * Valid values:
         * + `TimeBased` - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.
         * + `DistanceBased` - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.
         * + `AccuracyBased` - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations.
         *
         * This field is optional. If not specified, the default value is `TimeBased`.
         */
        public var positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = null
        /**
         * Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
         *
         * Format: `"key" : "value"`
         *
         * Restrictions:
         * + Maximum 50 tags per resource
         * + Each resource tag must be unique with a maximum of one value.
         * + Maximum key length: 128 Unicode characters in UTF-8
         * + Maximum value length: 256 Unicode characters in UTF-8
         * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         * + Cannot use "aws:" as a prefix for a key.
         */
        public var tags: Map<String, String>? = null
        /**
         * The name for the tracker resource.
         *
         * Requirements:
         * + Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
         * + Must be a unique tracker resource name.
         * + No spaces allowed. For example, `ExampleTracker`.
         */
        public var trackerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateTrackerRequest) : this() {
            this.description = x.description
            this.eventBridgeEnabled = x.eventBridgeEnabled
            this.kmsKeyEnableGeospatialQueries = x.kmsKeyEnableGeospatialQueries
            this.kmsKeyId = x.kmsKeyId
            this.positionFiltering = x.positionFiltering
            this.tags = x.tags
            this.trackerName = x.trackerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateTrackerRequest = CreateTrackerRequest(this)

        internal fun correctErrors(): Builder {
            if (trackerName == null) trackerName = ""
            return this
        }
    }
}
