// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


public class CreatePlaceIndexResponse private constructor(builder: Builder) {
    /**
     * The timestamp for when the place index resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex`
     */
    public val indexArn: kotlin.String = requireNotNull(builder.indexArn) { "A non-null value must be provided for indexArn" }
    /**
     * The name for the place index resource.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreatePlaceIndexResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePlaceIndexResponse(")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("indexArn=$indexArn,")
        append("indexName=$indexName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (this.indexArn.hashCode())
        result = 31 * result + (this.indexName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePlaceIndexResponse

        if (createTime != other.createTime) return false
        if (indexArn != other.indexArn) return false
        if (indexName != other.indexName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreatePlaceIndexResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp for when the place index resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex`
         */
        public var indexArn: kotlin.String? = null
        /**
         * The name for the place index resource.
         */
        public var indexName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreatePlaceIndexResponse) : this() {
            this.createTime = x.createTime
            this.indexArn = x.indexArn
            this.indexName = x.indexName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreatePlaceIndexResponse = CreatePlaceIndexResponse(this)

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (indexArn == null) indexArn = ""
            if (indexName == null) indexName = ""
            return this
        }
    }
}
