// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


public class CreateMapResponse private constructor(builder: Builder) {
    /**
     * The timestamp for when the map resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:map/ExampleMap`
     */
    public val mapArn: kotlin.String = requireNotNull(builder.mapArn) { "A non-null value must be provided for mapArn" }
    /**
     * The name of the map resource.
     */
    public val mapName: kotlin.String = requireNotNull(builder.mapName) { "A non-null value must be provided for mapName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateMapResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMapResponse(")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("mapArn=$mapArn,")
        append("mapName=$mapName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (this.mapArn.hashCode())
        result = 31 * result + (this.mapName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMapResponse

        if (createTime != other.createTime) return false
        if (mapArn != other.mapArn) return false
        if (mapName != other.mapName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateMapResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp for when the map resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:map/ExampleMap`
         */
        public var mapArn: kotlin.String? = null
        /**
         * The name of the map resource.
         */
        public var mapName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateMapResponse) : this() {
            this.createTime = x.createTime
            this.mapArn = x.mapArn
            this.mapName = x.mapName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateMapResponse = CreateMapResponse(this)

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (mapArn == null) mapArn = ""
            if (mapName == null) mapName = ""
            return this
        }
    }
}
