// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


public class CreateGeofenceCollectionResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection`
     */
    public val collectionArn: kotlin.String = requireNotNull(builder.collectionArn) { "A non-null value must be provided for collectionArn" }
    /**
     * The name for the geofence collection.
     */
    public val collectionName: kotlin.String = requireNotNull(builder.collectionName) { "A non-null value must be provided for collectionName" }
    /**
     * The timestamp for when the geofence collection was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGeofenceCollectionResponse(")
        append("collectionArn=$collectionArn,")
        append("collectionName=$collectionName,")
        append("createTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionArn.hashCode()
        result = 31 * result + (this.collectionName.hashCode())
        result = 31 * result + (this.createTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGeofenceCollectionResponse

        if (collectionArn != other.collectionArn) return false
        if (collectionName != other.collectionName) return false
        if (createTime != other.createTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection`
         */
        public var collectionArn: kotlin.String? = null
        /**
         * The name for the geofence collection.
         */
        public var collectionName: kotlin.String? = null
        /**
         * The timestamp for when the geofence collection was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionResponse) : this() {
            this.collectionArn = x.collectionArn
            this.collectionName = x.collectionName
            this.createTime = x.createTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionResponse = CreateGeofenceCollectionResponse(this)

        internal fun correctErrors(): Builder {
            if (collectionArn == null) collectionArn = ""
            if (collectionName == null) collectionName = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
