// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * A summary of the calculated route.
 */
public class CalculateRouteSummary private constructor(builder: Builder) {
    /**
     * The data provider of traffic and road network data used to calculate the route. Indicates one of the available providers:
     * + `Esri`
     * + `Grab`
     * + `Here`
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String = requireNotNull(builder.dataSource) { "A non-null value must be provided for dataSource" }
    /**
     * The total distance covered by the route. The sum of the distance travelled between every stop on the route.
     *
     * If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If the route exceeds 400 km, the response is a `400 RoutesValidationException` error.
     */
    public val distance: kotlin.Double = requireNotNull(builder.distance) { "A non-null value must be provided for distance" }
    /**
     * The unit of measurement for route distances.
     */
    public val distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit = requireNotNull(builder.distanceUnit) { "A non-null value must be provided for distanceUnit" }
    /**
     * The total travel time for the route measured in seconds. The sum of the travel time between every stop on the route.
     */
    public val durationSeconds: kotlin.Double = requireNotNull(builder.durationSeconds) { "A non-null value must be provided for durationSeconds" }
    /**
     * Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For example, `[min x, min y, max x, max y]`.
     *
     * The first 2 `bbox` parameters describe the lower southwest corner:
     * + The first `bbox` position is the X coordinate or longitude of the lower southwest corner.
     * + The second `bbox` position is the Y coordinate or latitude of the lower southwest corner.
     *
     * The next 2 `bbox` parameters describe the upper northeast corner:
     * + The third `bbox` position is the X coordinate, or longitude of the upper northeast corner.
     * + The fourth `bbox` position is the Y coordinate, or latitude of the upper northeast corner.
     */
    public val routeBBox: List<Double> = requireNotNull(builder.routeBBox) { "A non-null value must be provided for routeBBox" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CalculateRouteSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculateRouteSummary(")
        append("dataSource=$dataSource,")
        append("distance=*** Sensitive Data Redacted ***,")
        append("distanceUnit=$distanceUnit,")
        append("durationSeconds=*** Sensitive Data Redacted ***,")
        append("routeBBox=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource.hashCode()
        result = 31 * result + (this.distance.hashCode())
        result = 31 * result + (this.distanceUnit.hashCode())
        result = 31 * result + (this.durationSeconds.hashCode())
        result = 31 * result + (this.routeBBox.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculateRouteSummary

        if (dataSource != other.dataSource) return false
        if (!(distance?.equals(other.distance) ?: (other.distance == null))) return false
        if (distanceUnit != other.distanceUnit) return false
        if (!(durationSeconds?.equals(other.durationSeconds) ?: (other.durationSeconds == null))) return false
        if (routeBBox != other.routeBBox) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CalculateRouteSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The data provider of traffic and road network data used to calculate the route. Indicates one of the available providers:
         * + `Esri`
         * + `Grab`
         * + `Here`
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * The total distance covered by the route. The sum of the distance travelled between every stop on the route.
         *
         * If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If the route exceeds 400 km, the response is a `400 RoutesValidationException` error.
         */
        public var distance: kotlin.Double? = null
        /**
         * The unit of measurement for route distances.
         */
        public var distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit? = null
        /**
         * The total travel time for the route measured in seconds. The sum of the travel time between every stop on the route.
         */
        public var durationSeconds: kotlin.Double? = null
        /**
         * Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For example, `[min x, min y, max x, max y]`.
         *
         * The first 2 `bbox` parameters describe the lower southwest corner:
         * + The first `bbox` position is the X coordinate or longitude of the lower southwest corner.
         * + The second `bbox` position is the Y coordinate or latitude of the lower southwest corner.
         *
         * The next 2 `bbox` parameters describe the upper northeast corner:
         * + The third `bbox` position is the X coordinate, or longitude of the upper northeast corner.
         * + The fourth `bbox` position is the Y coordinate, or latitude of the upper northeast corner.
         */
        public var routeBBox: List<Double>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CalculateRouteSummary) : this() {
            this.dataSource = x.dataSource
            this.distance = x.distance
            this.distanceUnit = x.distanceUnit
            this.durationSeconds = x.durationSeconds
            this.routeBBox = x.routeBBox
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CalculateRouteSummary = CalculateRouteSummary(this)

        internal fun correctErrors(): Builder {
            if (dataSource == null) dataSource = ""
            if (distance == null) distance = 0.0
            if (distanceUnit == null) distanceUnit = DistanceUnit.SdkUnknown("no value provided")
            if (durationSeconds == null) durationSeconds = 0.0
            if (routeBBox == null) routeBBox = emptyList()
            return this
        }
    }
}
