// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.serde

import aws.sdk.kotlin.services.location.model.PositionFiltering
import aws.sdk.kotlin.services.location.model.UpdateTrackerRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateTrackerOperationSerializer: HttpSerializer.NonStreaming<UpdateTrackerRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateTrackerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("tracking"))
                add(PercentEncoding.Path.encode("v0"))
                add(PercentEncoding.Path.encode("trackers"))
                add(PercentEncoding.SmithyLabel.encode(input.trackerName))
            }
        }

        val payload = serializeUpdateTrackerOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateTrackerOperationBody(context: ExecutionContext, input: UpdateTrackerRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val EVENTBRIDGEENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EventBridgeEnabled"))
    val KMSKEYENABLEGEOSPATIALQUERIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("KmsKeyEnableGeospatialQueries"))
    val POSITIONFILTERING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PositionFiltering"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(EVENTBRIDGEENABLED_DESCRIPTOR)
        field(KMSKEYENABLEGEOSPATIALQUERIES_DESCRIPTOR)
        field(POSITIONFILTERING_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.eventBridgeEnabled?.let { field(EVENTBRIDGEENABLED_DESCRIPTOR, it) }
        input.kmsKeyEnableGeospatialQueries?.let { field(KMSKEYENABLEGEOSPATIALQUERIES_DESCRIPTOR, it) }
        input.positionFiltering?.let { field(POSITIONFILTERING_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
