// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


public class UpdateTrackerRequest private constructor(builder: Builder) {
    /**
     * Updates the description for the tracker resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Whether to enable position `UPDATE` events from this tracker to be sent to EventBridge.
     *
     * You do not need enable this feature to get `ENTER` and `EXIT` events for geofences with this tracker. Those events are always sent to EventBridge.
     */
    public val eventBridgeEnabled: kotlin.Boolean? = builder.eventBridgeEnabled
    /**
     * Enables `GeospatialQueries` for a tracker that uses a [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
     *
     * This parameter is only used if you are using a KMS customer managed key.
     */
    public val kmsKeyEnableGeospatialQueries: kotlin.Boolean? = builder.kmsKeyEnableGeospatialQueries
    /**
     * Updates the position filtering for the tracker resource.
     *
     * Valid values:
     * + `TimeBased` - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.
     * + `DistanceBased` - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.
     * + `AccuracyBased` - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations.
     */
    public val positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = builder.positionFiltering
    /**
     * The name of the tracker resource to update.
     */
    public val trackerName: kotlin.String = requireNotNull(builder.trackerName) { "A non-null value must be provided for trackerName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.UpdateTrackerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTrackerRequest(")
        append("description=$description,")
        append("eventBridgeEnabled=$eventBridgeEnabled,")
        append("kmsKeyEnableGeospatialQueries=$kmsKeyEnableGeospatialQueries,")
        append("positionFiltering=$positionFiltering,")
        append("trackerName=$trackerName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (this.eventBridgeEnabled?.hashCode() ?: 0)
        result = 31 * result + (this.kmsKeyEnableGeospatialQueries?.hashCode() ?: 0)
        result = 31 * result + (this.positionFiltering?.hashCode() ?: 0)
        result = 31 * result + (this.trackerName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTrackerRequest

        if (description != other.description) return false
        if (eventBridgeEnabled != other.eventBridgeEnabled) return false
        if (kmsKeyEnableGeospatialQueries != other.kmsKeyEnableGeospatialQueries) return false
        if (positionFiltering != other.positionFiltering) return false
        if (trackerName != other.trackerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.UpdateTrackerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Updates the description for the tracker resource.
         */
        public var description: kotlin.String? = null
        /**
         * Whether to enable position `UPDATE` events from this tracker to be sent to EventBridge.
         *
         * You do not need enable this feature to get `ENTER` and `EXIT` events for geofences with this tracker. Those events are always sent to EventBridge.
         */
        public var eventBridgeEnabled: kotlin.Boolean? = null
        /**
         * Enables `GeospatialQueries` for a tracker that uses a [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
         *
         * This parameter is only used if you are using a KMS customer managed key.
         */
        public var kmsKeyEnableGeospatialQueries: kotlin.Boolean? = null
        /**
         * Updates the position filtering for the tracker resource.
         *
         * Valid values:
         * + `TimeBased` - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.
         * + `DistanceBased` - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.
         * + `AccuracyBased` - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations.
         */
        public var positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = null
        /**
         * The name of the tracker resource to update.
         */
        public var trackerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.UpdateTrackerRequest) : this() {
            this.description = x.description
            this.eventBridgeEnabled = x.eventBridgeEnabled
            this.kmsKeyEnableGeospatialQueries = x.kmsKeyEnableGeospatialQueries
            this.positionFiltering = x.positionFiltering
            this.trackerName = x.trackerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.UpdateTrackerRequest = UpdateTrackerRequest(this)

        internal fun correctErrors(): Builder {
            if (trackerName == null) trackerName = ""
            return this
        }
    }
}
