// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Contains details about the truck dimensions in the unit of measurement that you specify. Used to filter out roads that can't support or allow the specified dimensions for requests that specify `TravelMode` as `Truck`.
 */
public class TruckDimensions private constructor(builder: Builder) {
    /**
     * The height of the truck.
     * + For example, `4.5`.
     *
     *  For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
     */
    public val height: kotlin.Double? = builder.height
    /**
     * The length of the truck.
     * + For example, `15.5`.
     *
     *  For routes calculated with a HERE resource, this value must be between 0 and 300 meters.
     */
    public val length: kotlin.Double? = builder.length
    /**
     * Specifies the unit of measurement for the truck dimensions.
     *
     * Default Value: `Meters`
     */
    public val unit: aws.sdk.kotlin.services.location.model.DimensionUnit? = builder.unit
    /**
     * The width of the truck.
     * + For example, `4.5`.
     *
     *  For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
     */
    public val width: kotlin.Double? = builder.width

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.TruckDimensions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TruckDimensions(")
        append("height=*** Sensitive Data Redacted ***,")
        append("length=*** Sensitive Data Redacted ***,")
        append("unit=$unit,")
        append("width=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = height?.hashCode() ?: 0
        result = 31 * result + (this.length?.hashCode() ?: 0)
        result = 31 * result + (this.unit?.hashCode() ?: 0)
        result = 31 * result + (this.width?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TruckDimensions

        if (!(height?.equals(other.height) ?: (other.height == null))) return false
        if (!(length?.equals(other.length) ?: (other.length == null))) return false
        if (unit != other.unit) return false
        if (!(width?.equals(other.width) ?: (other.width == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.TruckDimensions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The height of the truck.
         * + For example, `4.5`.
         *
         *  For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
         */
        public var height: kotlin.Double? = null
        /**
         * The length of the truck.
         * + For example, `15.5`.
         *
         *  For routes calculated with a HERE resource, this value must be between 0 and 300 meters.
         */
        public var length: kotlin.Double? = null
        /**
         * Specifies the unit of measurement for the truck dimensions.
         *
         * Default Value: `Meters`
         */
        public var unit: aws.sdk.kotlin.services.location.model.DimensionUnit? = null
        /**
         * The width of the truck.
         * + For example, `4.5`.
         *
         *  For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
         */
        public var width: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.TruckDimensions) : this() {
            this.height = x.height
            this.length = x.length
            this.unit = x.unit
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.TruckDimensions = TruckDimensions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
