// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


public class GetPlaceRequest private constructor(builder: Builder) {
    /**
     * The name of the place index resource that you want to use for the search.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The preferred language used to return results. The value must be a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
     *
     * This setting affects the languages used in the results, but not the results themselves. If no language is specified, or not supported for a particular result, the partner automatically chooses a language for the result.
     *
     * For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the `language` parameter set to `en`. The `city` in the results will most likely be returned as `Athens`.
     *
     * If you set the `language` parameter to `el`, for Greek, then the `city` in the results will more likely be returned as `Αθήνα`.
     *
     * If the data provider does not have a value for Greek, the result will be in a language that the provider does support.
     */
    public val language: kotlin.String? = builder.language
    /**
     * The identifier of the place to find.
     */
    public val placeId: kotlin.String = requireNotNull(builder.placeId) { "A non-null value must be provided for placeId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.GetPlaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetPlaceRequest(")
        append("indexName=$indexName,")
        append("key=*** Sensitive Data Redacted ***,")
        append("language=$language,")
        append("placeId=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexName.hashCode()
        result = 31 * result + (this.key?.hashCode() ?: 0)
        result = 31 * result + (this.language?.hashCode() ?: 0)
        result = 31 * result + (this.placeId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetPlaceRequest

        if (indexName != other.indexName) return false
        if (key != other.key) return false
        if (language != other.language) return false
        if (placeId != other.placeId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.GetPlaceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the place index resource that you want to use for the search.
         */
        public var indexName: kotlin.String? = null
        /**
         * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
         */
        public var key: kotlin.String? = null
        /**
         * The preferred language used to return results. The value must be a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
         *
         * This setting affects the languages used in the results, but not the results themselves. If no language is specified, or not supported for a particular result, the partner automatically chooses a language for the result.
         *
         * For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the `language` parameter set to `en`. The `city` in the results will most likely be returned as `Athens`.
         *
         * If you set the `language` parameter to `el`, for Greek, then the `city` in the results will more likely be returned as `Αθήνα`.
         *
         * If the data provider does not have a value for Greek, the result will be in a language that the provider does support.
         */
        public var language: kotlin.String? = null
        /**
         * The identifier of the place to find.
         */
        public var placeId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.GetPlaceRequest) : this() {
            this.indexName = x.indexName
            this.key = x.key
            this.language = x.language
            this.placeId = x.placeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.GetPlaceRequest = GetPlaceRequest(this)

        internal fun correctErrors(): Builder {
            if (indexName == null) indexName = ""
            if (placeId == null) placeId = ""
            return this
        }
    }
}
