// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.serde

import aws.sdk.kotlin.services.location.model.LocationException
import aws.sdk.kotlin.services.location.model.SearchForSuggestionsResult
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsResponse
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class SearchPlaceIndexForSuggestionsOperationDeserializer: HttpDeserializer.NonStreaming<SearchPlaceIndexForSuggestionsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SearchPlaceIndexForSuggestionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSearchPlaceIndexForSuggestionsError(context, call, payload)
        }
        val builder = SearchPlaceIndexForSuggestionsResponse.Builder()

        if (payload != null) {
            deserializeSearchPlaceIndexForSuggestionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSearchPlaceIndexForSuggestionsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LocationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LocationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchPlaceIndexForSuggestionsOperationBody(builder: SearchPlaceIndexForSuggestionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Results"))
    val SUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Summary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESULTS_DESCRIPTOR)
        field(SUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESULTS_DESCRIPTOR.index -> builder.results =
                    deserializer.deserializeList(RESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SearchForSuggestionsResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSearchForSuggestionsResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUMMARY_DESCRIPTOR.index -> builder.summary = deserializeSearchPlaceIndexForSuggestionsSummaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
