// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

private val awsSdkKotlinServicesLocationModelInferredStateDslBuilderRef = aws.sdk.kotlin.services.location.model.InferredState

public class VerifyDevicePositionResponse private constructor(builder: Builder) {
    /**
     * The device identifier.
     */
    public val deviceId: kotlin.String = requireNotNull(builder.deviceId) { "A non-null value must be provided for deviceId" }
    /**
     * The distance unit for the verification response.
     */
    public val distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit = requireNotNull(builder.distanceUnit) { "A non-null value must be provided for distanceUnit" }
    /**
     * The inferred state of the device, given the provided position, IP address, cellular signals, and Wi-Fi- access points.
     */
    public val inferredState: aws.sdk.kotlin.services.location.model.InferredState? = builder.inferredState
    /**
     * The timestamp for when the tracker resource received the device position in [ ISO 8601 ](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val receivedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.receivedTime) { "A non-null value must be provided for receivedTime" }
    /**
     * The timestamp at which the device's position was determined. Uses [ ISO 8601 ](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val sampleTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.sampleTime) { "A non-null value must be provided for sampleTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.VerifyDevicePositionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VerifyDevicePositionResponse(")
        append("deviceId=$deviceId,")
        append("distanceUnit=$distanceUnit,")
        append("inferredState=$inferredState,")
        append("receivedTime=*** Sensitive Data Redacted ***,")
        append("sampleTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceId.hashCode()
        result = 31 * result + (this.distanceUnit.hashCode())
        result = 31 * result + (this.inferredState?.hashCode() ?: 0)
        result = 31 * result + (this.receivedTime.hashCode())
        result = 31 * result + (this.sampleTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VerifyDevicePositionResponse

        if (deviceId != other.deviceId) return false
        if (distanceUnit != other.distanceUnit) return false
        if (inferredState != other.inferredState) return false
        if (receivedTime != other.receivedTime) return false
        if (sampleTime != other.sampleTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.VerifyDevicePositionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The device identifier.
         */
        public var deviceId: kotlin.String? = null
        /**
         * The distance unit for the verification response.
         */
        public var distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit? = null
        /**
         * The inferred state of the device, given the provided position, IP address, cellular signals, and Wi-Fi- access points.
         */
        public var inferredState: aws.sdk.kotlin.services.location.model.InferredState? = null
        /**
         * The timestamp for when the tracker resource received the device position in [ ISO 8601 ](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var receivedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp at which the device's position was determined. Uses [ ISO 8601 ](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var sampleTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.VerifyDevicePositionResponse) : this() {
            this.deviceId = x.deviceId
            this.distanceUnit = x.distanceUnit
            this.inferredState = x.inferredState
            this.receivedTime = x.receivedTime
            this.sampleTime = x.sampleTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.VerifyDevicePositionResponse = VerifyDevicePositionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.InferredState] inside the given [block]
         */
        public fun inferredState(block: aws.sdk.kotlin.services.location.model.InferredState.Builder.() -> kotlin.Unit) {
            this.inferredState = awsSdkKotlinServicesLocationModelInferredStateDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (deviceId == null) deviceId = ""
            if (distanceUnit == null) distanceUnit = DistanceUnit.SdkUnknown("no value provided")
            if (receivedTime == null) receivedTime = Instant.fromEpochSeconds(0)
            if (sampleTime == null) sampleTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
