// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


public class UpdateTrackerResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the updated tracker resource. Used to specify a resource across AWS.
     * + Format example: `arn:aws:geo:region:account-id:tracker/ExampleTracker`
     */
    public val trackerArn: kotlin.String = requireNotNull(builder.trackerArn) { "A non-null value must be provided for trackerArn" }
    /**
     * The name of the updated tracker resource.
     */
    public val trackerName: kotlin.String = requireNotNull(builder.trackerName) { "A non-null value must be provided for trackerName" }
    /**
     * The timestamp for when the tracker resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.UpdateTrackerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTrackerResponse(")
        append("trackerArn=$trackerArn,")
        append("trackerName=$trackerName,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = trackerArn.hashCode()
        result = 31 * result + (this.trackerName.hashCode())
        result = 31 * result + (this.updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTrackerResponse

        if (trackerArn != other.trackerArn) return false
        if (trackerName != other.trackerName) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.UpdateTrackerResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the updated tracker resource. Used to specify a resource across AWS.
         * + Format example: `arn:aws:geo:region:account-id:tracker/ExampleTracker`
         */
        public var trackerArn: kotlin.String? = null
        /**
         * The name of the updated tracker resource.
         */
        public var trackerName: kotlin.String? = null
        /**
         * The timestamp for when the tracker resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.UpdateTrackerResponse) : this() {
            this.trackerArn = x.trackerArn
            this.trackerName = x.trackerName
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.UpdateTrackerResponse = UpdateTrackerResponse(this)

        internal fun correctErrors(): Builder {
            if (trackerArn == null) trackerArn = ""
            if (trackerName == null) trackerName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
