// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


public class UpdatePlaceIndexResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the upated place index resource. Used to specify a resource across Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:place- index/ExamplePlaceIndex`
     */
    public val indexArn: kotlin.String = requireNotNull(builder.indexArn) { "A non-null value must be provided for indexArn" }
    /**
     * The name of the updated place index resource.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The timestamp for when the place index resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.UpdatePlaceIndexResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePlaceIndexResponse(")
        append("indexArn=$indexArn,")
        append("indexName=$indexName,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexArn.hashCode()
        result = 31 * result + (this.indexName.hashCode())
        result = 31 * result + (this.updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePlaceIndexResponse

        if (indexArn != other.indexArn) return false
        if (indexName != other.indexName) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.UpdatePlaceIndexResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the upated place index resource. Used to specify a resource across Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:place- index/ExamplePlaceIndex`
         */
        public var indexArn: kotlin.String? = null
        /**
         * The name of the updated place index resource.
         */
        public var indexName: kotlin.String? = null
        /**
         * The timestamp for when the place index resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.UpdatePlaceIndexResponse) : this() {
            this.indexArn = x.indexArn
            this.indexName = x.indexName
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.UpdatePlaceIndexResponse = UpdatePlaceIndexResponse(this)

        internal fun correctErrors(): Builder {
            if (indexArn == null) indexArn = ""
            if (indexName == null) indexName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
