// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


public class UpdateKeyResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the API key resource. Used when you need to specify a resource across all Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:key/ExampleKey`
     */
    public val keyArn: kotlin.String = requireNotNull(builder.keyArn) { "A non-null value must be provided for keyArn" }
    /**
     * The name of the API key resource.
     */
    public val keyName: kotlin.String = requireNotNull(builder.keyName) { "A non-null value must be provided for keyName" }
    /**
     * The timestamp for when the API key resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.UpdateKeyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateKeyResponse(")
        append("keyArn=$keyArn,")
        append("keyName=$keyName,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyArn.hashCode()
        result = 31 * result + (this.keyName.hashCode())
        result = 31 * result + (this.updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateKeyResponse

        if (keyArn != other.keyArn) return false
        if (keyName != other.keyName) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.UpdateKeyResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the API key resource. Used when you need to specify a resource across all Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:key/ExampleKey`
         */
        public var keyArn: kotlin.String? = null
        /**
         * The name of the API key resource.
         */
        public var keyName: kotlin.String? = null
        /**
         * The timestamp for when the API key resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.UpdateKeyResponse) : this() {
            this.keyArn = x.keyArn
            this.keyName = x.keyName
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.UpdateKeyResponse = UpdateKeyResponse(this)

        internal fun correctErrors(): Builder {
            if (keyArn == null) keyArn = ""
            if (keyName == null) keyName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
