// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * An error corresponding to the calculation of a route between the `DeparturePosition` and `DestinationPosition`.
 *
 * The error code can be one of the following:
 * + `RouteNotFound` - Unable to find a valid route with the given parameters.
 *
 * + `RouteTooLong` - Route calculation went beyond the maximum size of a route and was terminated before completion.
 *
 * + `PositionsNotFound` - One or more of the input positions were not found on the route network.
 *
 * + `DestinationPositionNotFound` - The destination position was not found on the route network.
 *
 * + `DeparturePositionNotFound` - The departure position was not found on the route network.
 *
 * + `OtherValidationError` - The given inputs were not valid or a route was not found. More information is given in the error `Message`
 */
public class RouteMatrixEntryError private constructor(builder: Builder) {
    /**
     * The type of error which occurred for the route calculation.
     */
    public val code: aws.sdk.kotlin.services.location.model.RouteMatrixErrorCode = requireNotNull(builder.code) { "A non-null value must be provided for code" }
    /**
     * A message about the error that occurred for the route calculation.
     */
    public val message: kotlin.String? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.RouteMatrixEntryError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RouteMatrixEntryError(")
        append("code=$code,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code.hashCode()
        result = 31 * result + (this.message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RouteMatrixEntryError

        if (code != other.code) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.RouteMatrixEntryError = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of error which occurred for the route calculation.
         */
        public var code: aws.sdk.kotlin.services.location.model.RouteMatrixErrorCode? = null
        /**
         * A message about the error that occurred for the route calculation.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.RouteMatrixEntryError) : this() {
            this.code = x.code
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.RouteMatrixEntryError = RouteMatrixEntryError(this)

        internal fun correctErrors(): Builder {
            if (code == null) code = RouteMatrixErrorCode.SdkUnknown("no value provided")
            return this
        }
    }
}
