// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesLocationModelPlaceGeometryDslBuilderRef = aws.sdk.kotlin.services.location.model.PlaceGeometry
private val awsSdkKotlinServicesLocationModelTimeZoneDslBuilderRef = aws.sdk.kotlin.services.location.model.TimeZone

/**
 * Contains details about addresses or points of interest that match the search criteria.
 *
 * Not all details are included with all responses. Some details may only be returned by specific data partners.
 */
public class Place private constructor(builder: Builder) {
    /**
     * The numerical portion of an address, such as a building number.
     */
    public val addressNumber: kotlin.String? = builder.addressNumber
    /**
     * The Amazon Location categories that describe this Place.
     *
     * For more information about using categories, including a list of Amazon Location categories, see [Categories and filtering](https://docs.aws.amazon.com/location/previous/developerguide/category-filtering.html), in the *Amazon Location Service developer guide*.
     */
    public val categories: List<String>? = builder.categories
    /**
     * A country/region specified using [ISO 3166](https://www.iso.org/iso-3166-country-codes.html) 3-digit country/region code. For example, `CAN`.
     */
    public val country: kotlin.String? = builder.country
    /**
     * Places uses a point geometry to specify a location or a Place.
     */
    public val geometry: aws.sdk.kotlin.services.location.model.PlaceGeometry? = builder.geometry
    /**
     * `True` if the result is interpolated from other known places.
     *
     * `False` if the Place is a known place.
     *
     * Not returned when the partner does not provide the information.
     *
     * For example, returns `False` for an address location that is found in the partner data, but returns `True` if an address does not exist in the partner data and its location is calculated by interpolating between other known addresses.
     */
    public val interpolated: kotlin.Boolean? = builder.interpolated
    /**
     * The full name and address of the point of interest such as a city, region, or country. For example, `123 Any Street, Any Town, USA`.
     */
    public val label: kotlin.String? = builder.label
    /**
     * A name for a local area, such as a city or town name. For example, `Toronto`.
     */
    public val municipality: kotlin.String? = builder.municipality
    /**
     * The name of a community district. For example, `Downtown`.
     */
    public val neighborhood: kotlin.String? = builder.neighborhood
    /**
     * A group of numbers and letters in a country-specific format, which accompanies the address for the purpose of identifying a location.
     */
    public val postalCode: kotlin.String? = builder.postalCode
    /**
     * A name for an area or geographical division, such as a province or state name. For example, `British Columbia`.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The name for a street or a road to identify a location. For example, `Main Street`.
     */
    public val street: kotlin.String? = builder.street
    /**
     * An area that's part of a larger municipality. For example, `Blissville ` is a submunicipality in the Queen County in New York.
     *
     * This property supported by Esri and OpenData. The Esri property is `district`, and the OpenData property is `borough`.
     */
    public val subMunicipality: kotlin.String? = builder.subMunicipality
    /**
     * A county, or an area that's part of a larger region. For example, `Metro Vancouver`.
     */
    public val subRegion: kotlin.String? = builder.subRegion
    /**
     * Categories from the data provider that describe the Place that are not mapped to any Amazon Location categories.
     */
    public val supplementalCategories: List<String>? = builder.supplementalCategories
    /**
     * The time zone in which the `Place` is located. Returned only when using HERE or Grab as the selected partner.
     */
    public val timeZone: aws.sdk.kotlin.services.location.model.TimeZone? = builder.timeZone
    /**
     * For addresses with multiple units, the unit identifier. Can include numbers and letters, for example `3B` or `Unit 123`.
     *
     * Returned only for a place index that uses Esri or Grab as a data provider. Is not returned for `SearchPlaceIndexForPosition`.
     */
    public val unitNumber: kotlin.String? = builder.unitNumber
    /**
     * For addresses with a `UnitNumber`, the type of unit. For example, `Apartment`.
     *
     * Returned only for a place index that uses Esri as a data provider.
     */
    public val unitType: kotlin.String? = builder.unitType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.Place = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Place(")
        append("addressNumber=*** Sensitive Data Redacted ***,")
        append("categories=*** Sensitive Data Redacted ***,")
        append("country=*** Sensitive Data Redacted ***,")
        append("geometry=$geometry,")
        append("interpolated=*** Sensitive Data Redacted ***,")
        append("label=*** Sensitive Data Redacted ***,")
        append("municipality=*** Sensitive Data Redacted ***,")
        append("neighborhood=*** Sensitive Data Redacted ***,")
        append("postalCode=*** Sensitive Data Redacted ***,")
        append("region=*** Sensitive Data Redacted ***,")
        append("street=*** Sensitive Data Redacted ***,")
        append("subMunicipality=*** Sensitive Data Redacted ***,")
        append("subRegion=*** Sensitive Data Redacted ***,")
        append("supplementalCategories=*** Sensitive Data Redacted ***,")
        append("timeZone=$timeZone,")
        append("unitNumber=*** Sensitive Data Redacted ***,")
        append("unitType=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressNumber?.hashCode() ?: 0
        result = 31 * result + (this.categories?.hashCode() ?: 0)
        result = 31 * result + (this.country?.hashCode() ?: 0)
        result = 31 * result + (this.geometry?.hashCode() ?: 0)
        result = 31 * result + (this.interpolated?.hashCode() ?: 0)
        result = 31 * result + (this.label?.hashCode() ?: 0)
        result = 31 * result + (this.municipality?.hashCode() ?: 0)
        result = 31 * result + (this.neighborhood?.hashCode() ?: 0)
        result = 31 * result + (this.postalCode?.hashCode() ?: 0)
        result = 31 * result + (this.region?.hashCode() ?: 0)
        result = 31 * result + (this.street?.hashCode() ?: 0)
        result = 31 * result + (this.subMunicipality?.hashCode() ?: 0)
        result = 31 * result + (this.subRegion?.hashCode() ?: 0)
        result = 31 * result + (this.supplementalCategories?.hashCode() ?: 0)
        result = 31 * result + (this.timeZone?.hashCode() ?: 0)
        result = 31 * result + (this.unitNumber?.hashCode() ?: 0)
        result = 31 * result + (this.unitType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Place

        if (addressNumber != other.addressNumber) return false
        if (categories != other.categories) return false
        if (country != other.country) return false
        if (geometry != other.geometry) return false
        if (interpolated != other.interpolated) return false
        if (label != other.label) return false
        if (municipality != other.municipality) return false
        if (neighborhood != other.neighborhood) return false
        if (postalCode != other.postalCode) return false
        if (region != other.region) return false
        if (street != other.street) return false
        if (subMunicipality != other.subMunicipality) return false
        if (subRegion != other.subRegion) return false
        if (supplementalCategories != other.supplementalCategories) return false
        if (timeZone != other.timeZone) return false
        if (unitNumber != other.unitNumber) return false
        if (unitType != other.unitType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.Place = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The numerical portion of an address, such as a building number.
         */
        public var addressNumber: kotlin.String? = null
        /**
         * The Amazon Location categories that describe this Place.
         *
         * For more information about using categories, including a list of Amazon Location categories, see [Categories and filtering](https://docs.aws.amazon.com/location/previous/developerguide/category-filtering.html), in the *Amazon Location Service developer guide*.
         */
        public var categories: List<String>? = null
        /**
         * A country/region specified using [ISO 3166](https://www.iso.org/iso-3166-country-codes.html) 3-digit country/region code. For example, `CAN`.
         */
        public var country: kotlin.String? = null
        /**
         * Places uses a point geometry to specify a location or a Place.
         */
        public var geometry: aws.sdk.kotlin.services.location.model.PlaceGeometry? = null
        /**
         * `True` if the result is interpolated from other known places.
         *
         * `False` if the Place is a known place.
         *
         * Not returned when the partner does not provide the information.
         *
         * For example, returns `False` for an address location that is found in the partner data, but returns `True` if an address does not exist in the partner data and its location is calculated by interpolating between other known addresses.
         */
        public var interpolated: kotlin.Boolean? = null
        /**
         * The full name and address of the point of interest such as a city, region, or country. For example, `123 Any Street, Any Town, USA`.
         */
        public var label: kotlin.String? = null
        /**
         * A name for a local area, such as a city or town name. For example, `Toronto`.
         */
        public var municipality: kotlin.String? = null
        /**
         * The name of a community district. For example, `Downtown`.
         */
        public var neighborhood: kotlin.String? = null
        /**
         * A group of numbers and letters in a country-specific format, which accompanies the address for the purpose of identifying a location.
         */
        public var postalCode: kotlin.String? = null
        /**
         * A name for an area or geographical division, such as a province or state name. For example, `British Columbia`.
         */
        public var region: kotlin.String? = null
        /**
         * The name for a street or a road to identify a location. For example, `Main Street`.
         */
        public var street: kotlin.String? = null
        /**
         * An area that's part of a larger municipality. For example, `Blissville ` is a submunicipality in the Queen County in New York.
         *
         * This property supported by Esri and OpenData. The Esri property is `district`, and the OpenData property is `borough`.
         */
        public var subMunicipality: kotlin.String? = null
        /**
         * A county, or an area that's part of a larger region. For example, `Metro Vancouver`.
         */
        public var subRegion: kotlin.String? = null
        /**
         * Categories from the data provider that describe the Place that are not mapped to any Amazon Location categories.
         */
        public var supplementalCategories: List<String>? = null
        /**
         * The time zone in which the `Place` is located. Returned only when using HERE or Grab as the selected partner.
         */
        public var timeZone: aws.sdk.kotlin.services.location.model.TimeZone? = null
        /**
         * For addresses with multiple units, the unit identifier. Can include numbers and letters, for example `3B` or `Unit 123`.
         *
         * Returned only for a place index that uses Esri or Grab as a data provider. Is not returned for `SearchPlaceIndexForPosition`.
         */
        public var unitNumber: kotlin.String? = null
        /**
         * For addresses with a `UnitNumber`, the type of unit. For example, `Apartment`.
         *
         * Returned only for a place index that uses Esri as a data provider.
         */
        public var unitType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.Place) : this() {
            this.addressNumber = x.addressNumber
            this.categories = x.categories
            this.country = x.country
            this.geometry = x.geometry
            this.interpolated = x.interpolated
            this.label = x.label
            this.municipality = x.municipality
            this.neighborhood = x.neighborhood
            this.postalCode = x.postalCode
            this.region = x.region
            this.street = x.street
            this.subMunicipality = x.subMunicipality
            this.subRegion = x.subRegion
            this.supplementalCategories = x.supplementalCategories
            this.timeZone = x.timeZone
            this.unitNumber = x.unitNumber
            this.unitType = x.unitType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.Place = Place(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.PlaceGeometry] inside the given [block]
         */
        public fun geometry(block: aws.sdk.kotlin.services.location.model.PlaceGeometry.Builder.() -> kotlin.Unit) {
            this.geometry = awsSdkKotlinServicesLocationModelPlaceGeometryDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.location.model.TimeZone] inside the given [block]
         */
        public fun timeZone(block: aws.sdk.kotlin.services.location.model.TimeZone.Builder.() -> kotlin.Unit) {
            this.timeZone = awsSdkKotlinServicesLocationModelTimeZoneDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
