// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


public class DescribeRouteCalculatorResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:route-calculator/ExampleCalculator`
     */
    public val calculatorArn: kotlin.String = requireNotNull(builder.calculatorArn) { "A non-null value must be provided for calculatorArn" }
    /**
     * The name of the route calculator resource being described.
     */
    public val calculatorName: kotlin.String = requireNotNull(builder.calculatorName) { "A non-null value must be provided for calculatorName" }
    /**
     * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     * + For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The data provider of traffic and road network data. Indicates one of the available providers:
     * + `Esri`
     * + `Grab`
     * + `Here`
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String = requireNotNull(builder.dataSource) { "A non-null value must be provided for dataSource" }
    /**
     * The optional description of the route calculator resource.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * Tags associated with route calculator resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timestamp when the route calculator resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     * + For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRouteCalculatorResponse(")
        append("calculatorArn=$calculatorArn,")
        append("calculatorName=$calculatorName,")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("dataSource=$dataSource,")
        append("description=$description,")
        append("tags=$tags,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = calculatorArn.hashCode()
        result = 31 * result + (this.calculatorName.hashCode())
        result = 31 * result + (this.createTime.hashCode())
        result = 31 * result + (this.dataSource.hashCode())
        result = 31 * result + (this.description.hashCode())
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        result = 31 * result + (this.updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRouteCalculatorResponse

        if (calculatorArn != other.calculatorArn) return false
        if (calculatorName != other.calculatorName) return false
        if (createTime != other.createTime) return false
        if (dataSource != other.dataSource) return false
        if (description != other.description) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:route-calculator/ExampleCalculator`
         */
        public var calculatorArn: kotlin.String? = null
        /**
         * The name of the route calculator resource being described.
         */
        public var calculatorName: kotlin.String? = null
        /**
         * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         * + For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data provider of traffic and road network data. Indicates one of the available providers:
         * + `Esri`
         * + `Grab`
         * + `Here`
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * The optional description of the route calculator resource.
         */
        public var description: kotlin.String? = null
        /**
         * Tags associated with route calculator resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timestamp when the route calculator resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         * + For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse) : this() {
            this.calculatorArn = x.calculatorArn
            this.calculatorName = x.calculatorName
            this.createTime = x.createTime
            this.dataSource = x.dataSource
            this.description = x.description
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse = DescribeRouteCalculatorResponse(this)

        internal fun correctErrors(): Builder {
            if (calculatorArn == null) calculatorArn = ""
            if (calculatorName == null) calculatorName = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (dataSource == null) dataSource = ""
            if (description == null) description = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
