// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * A summary of the calculated route matrix.
 */
public class CalculateRouteMatrixSummary private constructor(builder: Builder) {
    /**
     * The data provider of traffic and road network data used to calculate the routes. Indicates one of the available providers:
     * + `Esri`
     * + `Grab`
     * + `Here`
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String = requireNotNull(builder.dataSource) { "A non-null value must be provided for dataSource" }
    /**
     * The unit of measurement for route distances.
     */
    public val distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit = requireNotNull(builder.distanceUnit) { "A non-null value must be provided for distanceUnit" }
    /**
     * The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.
     */
    public val errorCount: kotlin.Int = requireNotNull(builder.errorCount) { "A non-null value must be provided for errorCount" }
    /**
     * The count of cells in the route matrix. Equal to the number of `DeparturePositions` multiplied by the number of `DestinationPositions`.
     */
    public val routeCount: kotlin.Int = requireNotNull(builder.routeCount) { "A non-null value must be provided for routeCount" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculateRouteMatrixSummary(")
        append("dataSource=$dataSource,")
        append("distanceUnit=$distanceUnit,")
        append("errorCount=$errorCount,")
        append("routeCount=$routeCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource.hashCode()
        result = 31 * result + (this.distanceUnit.hashCode())
        result = 31 * result + (this.errorCount)
        result = 31 * result + (this.routeCount)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculateRouteMatrixSummary

        if (dataSource != other.dataSource) return false
        if (distanceUnit != other.distanceUnit) return false
        if (errorCount != other.errorCount) return false
        if (routeCount != other.routeCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The data provider of traffic and road network data used to calculate the routes. Indicates one of the available providers:
         * + `Esri`
         * + `Grab`
         * + `Here`
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * The unit of measurement for route distances.
         */
        public var distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit? = null
        /**
         * The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.
         */
        public var errorCount: kotlin.Int? = null
        /**
         * The count of cells in the route matrix. Equal to the number of `DeparturePositions` multiplied by the number of `DestinationPositions`.
         */
        public var routeCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary) : this() {
            this.dataSource = x.dataSource
            this.distanceUnit = x.distanceUnit
            this.errorCount = x.errorCount
            this.routeCount = x.routeCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary = CalculateRouteMatrixSummary(this)

        internal fun correctErrors(): Builder {
            if (dataSource == null) dataSource = ""
            if (distanceUnit == null) distanceUnit = DistanceUnit.SdkUnknown("no value provided")
            if (errorCount == null) errorCount = 0
            if (routeCount == null) routeCount = 0
            return this
        }
    }
}
