// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Represents an element of a leg within a route. A step contains instructions for how to move to the next step in the leg.
 */
public class Step private constructor(builder: Builder) {
    /**
     * The travel distance between the step's `StartPosition` and `EndPosition`.
     */
    public val distance: kotlin.Double = requireNotNull(builder.distance) { "A non-null value must be provided for distance" }
    /**
     * The estimated travel time, in seconds, from the step's `StartPosition` to the `EndPosition`. . The travel mode and departure time that you specify in the request determines the calculated time.
     */
    public val durationSeconds: kotlin.Double = requireNotNull(builder.durationSeconds) { "A non-null value must be provided for durationSeconds" }
    /**
     * The end position of a step. If the position the last step in the leg, this position is the same as the end position of the leg.
     */
    public val endPosition: List<Double> = requireNotNull(builder.endPosition) { "A non-null value must be provided for endPosition" }
    /**
     * Represents the start position, or index, in a sequence of steps within the leg's line string geometry. For example, the index of the first step in a leg geometry is `0`.
     *
     * Included in the response for queries that set `IncludeLegGeometry` to `True`.
     */
    public val geometryOffset: kotlin.Int? = builder.geometryOffset
    /**
     * The starting position of a step. If the position is the first step in the leg, this position is the same as the start position of the leg.
     */
    public val startPosition: List<Double> = requireNotNull(builder.startPosition) { "A non-null value must be provided for startPosition" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.Step = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Step(")
        append("distance=$distance,")
        append("durationSeconds=$durationSeconds,")
        append("endPosition=*** Sensitive Data Redacted ***,")
        append("geometryOffset=$geometryOffset,")
        append("startPosition=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = distance.hashCode()
        result = 31 * result + (this.durationSeconds.hashCode())
        result = 31 * result + (this.endPosition.hashCode())
        result = 31 * result + (this.geometryOffset ?: 0)
        result = 31 * result + (this.startPosition.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Step

        if (!(distance?.equals(other.distance) ?: (other.distance == null))) return false
        if (!(durationSeconds?.equals(other.durationSeconds) ?: (other.durationSeconds == null))) return false
        if (endPosition != other.endPosition) return false
        if (geometryOffset != other.geometryOffset) return false
        if (startPosition != other.startPosition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.Step = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The travel distance between the step's `StartPosition` and `EndPosition`.
         */
        public var distance: kotlin.Double? = null
        /**
         * The estimated travel time, in seconds, from the step's `StartPosition` to the `EndPosition`. . The travel mode and departure time that you specify in the request determines the calculated time.
         */
        public var durationSeconds: kotlin.Double? = null
        /**
         * The end position of a step. If the position the last step in the leg, this position is the same as the end position of the leg.
         */
        public var endPosition: List<Double>? = null
        /**
         * Represents the start position, or index, in a sequence of steps within the leg's line string geometry. For example, the index of the first step in a leg geometry is `0`.
         *
         * Included in the response for queries that set `IncludeLegGeometry` to `True`.
         */
        public var geometryOffset: kotlin.Int? = null
        /**
         * The starting position of a step. If the position is the first step in the leg, this position is the same as the start position of the leg.
         */
        public var startPosition: List<Double>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.Step) : this() {
            this.distance = x.distance
            this.durationSeconds = x.durationSeconds
            this.endPosition = x.endPosition
            this.geometryOffset = x.geometryOffset
            this.startPosition = x.startPosition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.Step = Step(this)

        internal fun correctErrors(): Builder {
            if (distance == null) distance = 0.0
            if (durationSeconds == null) durationSeconds = 0.0
            if (endPosition == null) endPosition = emptyList()
            if (startPosition == null) startPosition = emptyList()
            return this
        }
    }
}
