// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


public class SearchPlaceIndexForTextRequest private constructor(builder: Builder) {
    /**
     * An optional parameter that indicates a preference for places that are closer to a specified position.
     *
     *  If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.
     *
     * For example, `[-123.1174, 49.2847]` represents the position with longitude `-123.1174` and latitude `49.2847`.
     *
     * `BiasPosition` and `FilterBBox` are mutually exclusive. Specifying both options results in an error.
     */
    public val biasPosition: List<Double>? = builder.biasPosition
    /**
     * An optional parameter that limits the search results by returning only places that are within the provided bounding box.
     *
     *  If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.
     *
     * For example, `[-12.7935, -37.4835, -12.0684, -36.9542]` represents a bounding box where the southwest corner has longitude `-12.7935` and latitude `-37.4835`, and the northeast corner has longitude `-12.0684` and latitude `-36.9542`.
     *
     * `FilterBBox` and `BiasPosition` are mutually exclusive. Specifying both options results in an error.
     */
    public val filterBBox: List<Double>? = builder.filterBBox
    /**
     * A list of one or more Amazon Location categories to filter the returned places. If you include more than one category, the results will include results that match *any* of the categories listed.
     *
     * For more information about using categories, including a list of Amazon Location categories, see [Categories and filtering](https://docs.aws.amazon.com/location/previous/developerguide/category-filtering.html), in the *Amazon Location Service developer guide*.
     */
    public val filterCategories: List<String>? = builder.filterCategories
    /**
     * An optional parameter that limits the search results by returning only places that are in a specified list of countries.
     * + Valid values include [ISO 3166](https://www.iso.org/iso-3166-country-codes.html) 3-digit country codes. For example, Australia uses three upper-case characters: `AUS`.
     */
    public val filterCountries: List<String>? = builder.filterCountries
    /**
     * The name of the place index resource you want to use for the search.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The preferred language used to return results. The value must be a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
     *
     * This setting affects the languages used in the results, but not the results themselves. If no language is specified, or not supported for a particular result, the partner automatically chooses a language for the result.
     *
     * For an example, we'll use the Greek language. You search for `Athens, Greece`, with the `language` parameter set to `en`. The result found will most likely be returned as `Athens`.
     *
     * If you set the `language` parameter to `el`, for Greek, then the result found will more likely be returned as `Αθήνα`.
     *
     * If the data provider does not have a value for Greek, the result will be in a language that the provider does support.
     */
    public val language: kotlin.String? = builder.language
    /**
     * An optional parameter. The maximum number of results returned per request.
     *
     * The default: `50`
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The address, name, city, or region to be used in the search in free-form text format. For example, `123 Any Street`.
     */
    public val text: kotlin.String = requireNotNull(builder.text) { "A non-null value must be provided for text" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchPlaceIndexForTextRequest(")
        append("biasPosition=*** Sensitive Data Redacted ***,")
        append("filterBBox=*** Sensitive Data Redacted ***,")
        append("filterCategories=$filterCategories,")
        append("filterCountries=*** Sensitive Data Redacted ***,")
        append("indexName=$indexName,")
        append("key=*** Sensitive Data Redacted ***,")
        append("language=$language,")
        append("maxResults=$maxResults,")
        append("text=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = biasPosition?.hashCode() ?: 0
        result = 31 * result + (this.filterBBox?.hashCode() ?: 0)
        result = 31 * result + (this.filterCategories?.hashCode() ?: 0)
        result = 31 * result + (this.filterCountries?.hashCode() ?: 0)
        result = 31 * result + (this.indexName.hashCode())
        result = 31 * result + (this.key?.hashCode() ?: 0)
        result = 31 * result + (this.language?.hashCode() ?: 0)
        result = 31 * result + (this.maxResults ?: 0)
        result = 31 * result + (this.text.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchPlaceIndexForTextRequest

        if (biasPosition != other.biasPosition) return false
        if (filterBBox != other.filterBBox) return false
        if (filterCategories != other.filterCategories) return false
        if (filterCountries != other.filterCountries) return false
        if (indexName != other.indexName) return false
        if (key != other.key) return false
        if (language != other.language) return false
        if (maxResults != other.maxResults) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional parameter that indicates a preference for places that are closer to a specified position.
         *
         *  If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.
         *
         * For example, `[-123.1174, 49.2847]` represents the position with longitude `-123.1174` and latitude `49.2847`.
         *
         * `BiasPosition` and `FilterBBox` are mutually exclusive. Specifying both options results in an error.
         */
        public var biasPosition: List<Double>? = null
        /**
         * An optional parameter that limits the search results by returning only places that are within the provided bounding box.
         *
         *  If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.
         *
         * For example, `[-12.7935, -37.4835, -12.0684, -36.9542]` represents a bounding box where the southwest corner has longitude `-12.7935` and latitude `-37.4835`, and the northeast corner has longitude `-12.0684` and latitude `-36.9542`.
         *
         * `FilterBBox` and `BiasPosition` are mutually exclusive. Specifying both options results in an error.
         */
        public var filterBBox: List<Double>? = null
        /**
         * A list of one or more Amazon Location categories to filter the returned places. If you include more than one category, the results will include results that match *any* of the categories listed.
         *
         * For more information about using categories, including a list of Amazon Location categories, see [Categories and filtering](https://docs.aws.amazon.com/location/previous/developerguide/category-filtering.html), in the *Amazon Location Service developer guide*.
         */
        public var filterCategories: List<String>? = null
        /**
         * An optional parameter that limits the search results by returning only places that are in a specified list of countries.
         * + Valid values include [ISO 3166](https://www.iso.org/iso-3166-country-codes.html) 3-digit country codes. For example, Australia uses three upper-case characters: `AUS`.
         */
        public var filterCountries: List<String>? = null
        /**
         * The name of the place index resource you want to use for the search.
         */
        public var indexName: kotlin.String? = null
        /**
         * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
         */
        public var key: kotlin.String? = null
        /**
         * The preferred language used to return results. The value must be a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
         *
         * This setting affects the languages used in the results, but not the results themselves. If no language is specified, or not supported for a particular result, the partner automatically chooses a language for the result.
         *
         * For an example, we'll use the Greek language. You search for `Athens, Greece`, with the `language` parameter set to `en`. The result found will most likely be returned as `Athens`.
         *
         * If you set the `language` parameter to `el`, for Greek, then the result found will more likely be returned as `Αθήνα`.
         *
         * If the data provider does not have a value for Greek, the result will be in a language that the provider does support.
         */
        public var language: kotlin.String? = null
        /**
         * An optional parameter. The maximum number of results returned per request.
         *
         * The default: `50`
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The address, name, city, or region to be used in the search in free-form text format. For example, `123 Any Street`.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextRequest) : this() {
            this.biasPosition = x.biasPosition
            this.filterBBox = x.filterBBox
            this.filterCategories = x.filterCategories
            this.filterCountries = x.filterCountries
            this.indexName = x.indexName
            this.key = x.key
            this.language = x.language
            this.maxResults = x.maxResults
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextRequest = SearchPlaceIndexForTextRequest(this)

        internal fun correctErrors(): Builder {
            if (indexName == null) indexName = ""
            if (text == null) text = ""
            return this
        }
    }
}
