// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesLocationModelPlaceDslBuilderRef = aws.sdk.kotlin.services.location.model.Place

/**
 * Contains a search result from a position search query that is run on a place index resource.
 */
public class SearchForPositionResult private constructor(builder: Builder) {
    /**
     * The distance in meters of a great-circle arc between the query position and the result.
     *
     * A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.
     */
    public val distance: kotlin.Double = requireNotNull(builder.distance) { "A non-null value must be provided for distance" }
    /**
     * Details about the search result, such as its address and position.
     */
    public val place: aws.sdk.kotlin.services.location.model.Place? = builder.place
    /**
     * The unique identifier of the place. You can use this with the `GetPlace` operation to find the place again later.
     *
     * For `SearchPlaceIndexForPosition` operations, the `PlaceId` is returned only by place indexes that use HERE or Grab as a data provider.
     */
    public val placeId: kotlin.String? = builder.placeId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.SearchForPositionResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchForPositionResult(")
        append("distance=$distance,")
        append("place=$place,")
        append("placeId=$placeId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = distance.hashCode()
        result = 31 * result + (this.place?.hashCode() ?: 0)
        result = 31 * result + (this.placeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchForPositionResult

        if (!(distance?.equals(other.distance) ?: (other.distance == null))) return false
        if (place != other.place) return false
        if (placeId != other.placeId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.SearchForPositionResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The distance in meters of a great-circle arc between the query position and the result.
         *
         * A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.
         */
        public var distance: kotlin.Double? = null
        /**
         * Details about the search result, such as its address and position.
         */
        public var place: aws.sdk.kotlin.services.location.model.Place? = null
        /**
         * The unique identifier of the place. You can use this with the `GetPlace` operation to find the place again later.
         *
         * For `SearchPlaceIndexForPosition` operations, the `PlaceId` is returned only by place indexes that use HERE or Grab as a data provider.
         */
        public var placeId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.SearchForPositionResult) : this() {
            this.distance = x.distance
            this.place = x.place
            this.placeId = x.placeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.SearchForPositionResult = SearchForPositionResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.Place] inside the given [block]
         */
        public fun place(block: aws.sdk.kotlin.services.location.model.Place.Builder.() -> kotlin.Unit) {
            this.place = awsSdkKotlinServicesLocationModelPlaceDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (distance == null) distance = 0.0
            return this
        }
    }
}
