// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

private val awsSdkKotlinServicesLocationModelPositionalAccuracyDslBuilderRef = aws.sdk.kotlin.services.location.model.PositionalAccuracy

/**
 * Contains the tracker resource details.
 */
public class ListDevicePositionsResponseEntry private constructor(builder: Builder) {
    /**
     * The accuracy of the device position.
     */
    public val accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = builder.accuracy
    /**
     * The ID of the device for this position.
     */
    public val deviceId: kotlin.String = requireNotNull(builder.deviceId) { "A non-null value must be provided for deviceId" }
    /**
     * The last known device position. Empty if no positions currently stored.
     */
    public val position: List<Double> = requireNotNull(builder.position) { "A non-null value must be provided for position" }
    /**
     * The properties associated with the position.
     */
    public val positionProperties: Map<String, String>? = builder.positionProperties
    /**
     * The timestamp at which the device position was determined. Uses [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val sampleTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.sampleTime) { "A non-null value must be provided for sampleTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ListDevicePositionsResponseEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDevicePositionsResponseEntry(")
        append("accuracy=$accuracy,")
        append("deviceId=$deviceId,")
        append("position=*** Sensitive Data Redacted ***,")
        append("positionProperties=*** Sensitive Data Redacted ***,")
        append("sampleTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accuracy?.hashCode() ?: 0
        result = 31 * result + (this.deviceId.hashCode())
        result = 31 * result + (this.position.hashCode())
        result = 31 * result + (this.positionProperties?.hashCode() ?: 0)
        result = 31 * result + (this.sampleTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDevicePositionsResponseEntry

        if (accuracy != other.accuracy) return false
        if (deviceId != other.deviceId) return false
        if (position != other.position) return false
        if (positionProperties != other.positionProperties) return false
        if (sampleTime != other.sampleTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ListDevicePositionsResponseEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The accuracy of the device position.
         */
        public var accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = null
        /**
         * The ID of the device for this position.
         */
        public var deviceId: kotlin.String? = null
        /**
         * The last known device position. Empty if no positions currently stored.
         */
        public var position: List<Double>? = null
        /**
         * The properties associated with the position.
         */
        public var positionProperties: Map<String, String>? = null
        /**
         * The timestamp at which the device position was determined. Uses [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var sampleTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ListDevicePositionsResponseEntry) : this() {
            this.accuracy = x.accuracy
            this.deviceId = x.deviceId
            this.position = x.position
            this.positionProperties = x.positionProperties
            this.sampleTime = x.sampleTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ListDevicePositionsResponseEntry = ListDevicePositionsResponseEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.PositionalAccuracy] inside the given [block]
         */
        public fun accuracy(block: aws.sdk.kotlin.services.location.model.PositionalAccuracy.Builder.() -> kotlin.Unit) {
            this.accuracy = awsSdkKotlinServicesLocationModelPositionalAccuracyDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (deviceId == null) deviceId = ""
            if (position == null) position = emptyList()
            if (sampleTime == null) sampleTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
