// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Specifies the data storage option chosen for requesting Places.
 *
 * When using Amazon Location Places:
 * + If using HERE Technologies as a data provider, you can't store results for locations in Japan by setting `IntendedUse` to `Storage`. parameter.
 * + Under the `MobileAssetTracking` or `MobilAssetManagement` pricing plan, you can't store results from your place index resources by setting `IntendedUse` to `Storage`. This returns a validation exception error.
 * For more information, see the [AWS Service Terms](https://aws.amazon.com/service-terms/) for Amazon Location Service.
 */
public class DataSourceConfiguration private constructor(builder: Builder) {
    /**
     * Specifies how the results of an operation will be stored by the caller.
     *
     * Valid values include:
     * + `SingleUse` specifies that the results won't be stored.
     * + `Storage` specifies that the result can be cached or stored in a database.
     *
     * Default value: `SingleUse`
     */
    public val intendedUse: aws.sdk.kotlin.services.location.model.IntendedUse? = builder.intendedUse

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DataSourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceConfiguration(")
        append("intendedUse=$intendedUse")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = intendedUse?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceConfiguration

        if (intendedUse != other.intendedUse) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DataSourceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies how the results of an operation will be stored by the caller.
         *
         * Valid values include:
         * + `SingleUse` specifies that the results won't be stored.
         * + `Storage` specifies that the result can be cached or stored in a database.
         *
         * Default value: `SingleUse`
         */
        public var intendedUse: aws.sdk.kotlin.services.location.model.IntendedUse? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DataSourceConfiguration) : this() {
            this.intendedUse = x.intendedUse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DataSourceConfiguration = DataSourceConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
