// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

private val awsSdkKotlinServicesLocationModelCalculateRouteCarModeOptionsDslBuilderRef = aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions
private val awsSdkKotlinServicesLocationModelCalculateRouteTruckModeOptionsDslBuilderRef = aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions

public class CalculateRouteRequest private constructor(builder: Builder) {
    /**
     * Specifies the desired time of arrival. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.
     *
     * ArrivalTime is not supported Esri.
     */
    public val arrivalTime: aws.smithy.kotlin.runtime.time.Instant? = builder.arrivalTime
    /**
     * The name of the route calculator resource that you want to use to calculate the route.
     */
    public val calculatorName: kotlin.String = requireNotNull(builder.calculatorName) { "A non-null value must be provided for calculatorName" }
    /**
     * Specifies route preferences when traveling by `Car`, such as avoiding routes that use ferries or tolls.
     *
     * Requirements: `TravelMode` must be specified as `Car`.
     */
    public val carModeOptions: aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions? = builder.carModeOptions
    /**
     * Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.
     *
     * Default Value: `false`
     *
     * Valid Values: `false` | `true`
     */
    public val departNow: kotlin.Boolean? = builder.departNow
    /**
     * The start position for the route. Defined in [World Geodetic System (WGS 84)](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format: `[longitude, latitude]`.
     * + For example, `[-123.115, 49.285]`
     *
     * If you specify a departure that's not located on a road, Amazon Location [moves the position to the nearest road](https://docs.aws.amazon.com/location/previous/developerguide/snap-to-nearby-road.html). If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a `400 RoutesValidationException` error.
     *
     * Valid Values: `[-180 to 180,-90 to 90]`
     */
    public val departurePosition: List<Double> = requireNotNull(builder.departurePosition) { "A non-null value must be provided for departurePosition" }
    /**
     * Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.
     * + In [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val departureTime: aws.smithy.kotlin.runtime.time.Instant? = builder.departureTime
    /**
     * The finish position for the route. Defined in [World Geodetic System (WGS 84)](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format: `[longitude, latitude]`.
     * +  For example, `[-122.339, 47.615]`
     *
     * If you specify a destination that's not located on a road, Amazon Location [moves the position to the nearest road](https://docs.aws.amazon.com/location/previous/developerguide/snap-to-nearby-road.html).
     *
     * Valid Values: `[-180 to 180,-90 to 90]`
     */
    public val destinationPosition: List<Double> = requireNotNull(builder.destinationPosition) { "A non-null value must be provided for destinationPosition" }
    /**
     * Set the unit system to specify the distance.
     *
     * Default Value: `Kilometers`
     */
    public val distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit? = builder.distanceUnit
    /**
     * Set to include the geometry details in the result for each path between a pair of positions.
     *
     * Default Value: `false`
     *
     * Valid Values: `false` | `true`
     */
    public val includeLegGeometry: kotlin.Boolean? = builder.includeLegGeometry
    /**
     * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Specifies the distance to optimize for when calculating a route.
     */
    public val optimizeFor: aws.sdk.kotlin.services.location.model.OptimizationMode? = builder.optimizeFor
    /**
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility. You can choose `Car`, `Truck`, `Walking`, `Bicycle` or `Motorcycle` as options for the `TravelMode`.
     *
     * `Bicycle` and `Motorcycle` are only valid when using Grab as a data provider, and only within Southeast Asia.
     *
     * `Truck` is not available for Grab.
     *
     * For more details on the using Grab for routing, including areas of coverage, see [GrabMaps](https://docs.aws.amazon.com/location/previous/developerguide/grab.html) in the *Amazon Location Service Developer Guide*.
     *
     * The `TravelMode` you specify also determines how you specify route preferences:
     * + If traveling by `Car` use the `CarModeOptions` parameter.
     * + If traveling by `Truck` use the `TruckModeOptions` parameter.
     *
     * Default Value: `Car`
     */
    public val travelMode: aws.sdk.kotlin.services.location.model.TravelMode? = builder.travelMode
    /**
     * Specifies route preferences when traveling by `Truck`, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.
     *
     * Requirements: `TravelMode` must be specified as `Truck`.
     */
    public val truckModeOptions: aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions? = builder.truckModeOptions
    /**
     * Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position.
     * + For example, from the `DeparturePosition``[-123.115, 49.285]`, the route follows the order that the waypoint positions are given `[[-122.757, 49.0021],[-122.349, 47.620]]`
     *
     * If you specify a waypoint position that's not located on a road, Amazon Location [moves the position to the nearest road](https://docs.aws.amazon.com/location/previous/developerguide/snap-to-nearby-road.html).
     *
     * Specifying more than 23 waypoints returns a `400 ValidationException` error.
     *
     * If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a `400 RoutesValidationException` error.
     *
     * Valid Values: `[-180 to 180,-90 to 90]`
     */
    public val waypointPositions: List<List<Double>>? = builder.waypointPositions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CalculateRouteRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculateRouteRequest(")
        append("arrivalTime=*** Sensitive Data Redacted ***,")
        append("calculatorName=$calculatorName,")
        append("carModeOptions=$carModeOptions,")
        append("departNow=$departNow,")
        append("departurePosition=*** Sensitive Data Redacted ***,")
        append("departureTime=*** Sensitive Data Redacted ***,")
        append("destinationPosition=*** Sensitive Data Redacted ***,")
        append("distanceUnit=$distanceUnit,")
        append("includeLegGeometry=$includeLegGeometry,")
        append("key=*** Sensitive Data Redacted ***,")
        append("optimizeFor=$optimizeFor,")
        append("travelMode=$travelMode,")
        append("truckModeOptions=$truckModeOptions,")
        append("waypointPositions=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arrivalTime?.hashCode() ?: 0
        result = 31 * result + (this.calculatorName.hashCode())
        result = 31 * result + (this.carModeOptions?.hashCode() ?: 0)
        result = 31 * result + (this.departNow?.hashCode() ?: 0)
        result = 31 * result + (this.departurePosition.hashCode())
        result = 31 * result + (this.departureTime?.hashCode() ?: 0)
        result = 31 * result + (this.destinationPosition.hashCode())
        result = 31 * result + (this.distanceUnit?.hashCode() ?: 0)
        result = 31 * result + (this.includeLegGeometry?.hashCode() ?: 0)
        result = 31 * result + (this.key?.hashCode() ?: 0)
        result = 31 * result + (this.optimizeFor?.hashCode() ?: 0)
        result = 31 * result + (this.travelMode?.hashCode() ?: 0)
        result = 31 * result + (this.truckModeOptions?.hashCode() ?: 0)
        result = 31 * result + (this.waypointPositions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculateRouteRequest

        if (arrivalTime != other.arrivalTime) return false
        if (calculatorName != other.calculatorName) return false
        if (carModeOptions != other.carModeOptions) return false
        if (departNow != other.departNow) return false
        if (departurePosition != other.departurePosition) return false
        if (departureTime != other.departureTime) return false
        if (destinationPosition != other.destinationPosition) return false
        if (distanceUnit != other.distanceUnit) return false
        if (includeLegGeometry != other.includeLegGeometry) return false
        if (key != other.key) return false
        if (optimizeFor != other.optimizeFor) return false
        if (travelMode != other.travelMode) return false
        if (truckModeOptions != other.truckModeOptions) return false
        if (waypointPositions != other.waypointPositions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CalculateRouteRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the desired time of arrival. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.
         *
         * ArrivalTime is not supported Esri.
         */
        public var arrivalTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the route calculator resource that you want to use to calculate the route.
         */
        public var calculatorName: kotlin.String? = null
        /**
         * Specifies route preferences when traveling by `Car`, such as avoiding routes that use ferries or tolls.
         *
         * Requirements: `TravelMode` must be specified as `Car`.
         */
        public var carModeOptions: aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions? = null
        /**
         * Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.
         *
         * Default Value: `false`
         *
         * Valid Values: `false` | `true`
         */
        public var departNow: kotlin.Boolean? = null
        /**
         * The start position for the route. Defined in [World Geodetic System (WGS 84)](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format: `[longitude, latitude]`.
         * + For example, `[-123.115, 49.285]`
         *
         * If you specify a departure that's not located on a road, Amazon Location [moves the position to the nearest road](https://docs.aws.amazon.com/location/previous/developerguide/snap-to-nearby-road.html). If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a `400 RoutesValidationException` error.
         *
         * Valid Values: `[-180 to 180,-90 to 90]`
         */
        public var departurePosition: List<Double>? = null
        /**
         * Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.
         * + In [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var departureTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The finish position for the route. Defined in [World Geodetic System (WGS 84)](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format: `[longitude, latitude]`.
         * +  For example, `[-122.339, 47.615]`
         *
         * If you specify a destination that's not located on a road, Amazon Location [moves the position to the nearest road](https://docs.aws.amazon.com/location/previous/developerguide/snap-to-nearby-road.html).
         *
         * Valid Values: `[-180 to 180,-90 to 90]`
         */
        public var destinationPosition: List<Double>? = null
        /**
         * Set the unit system to specify the distance.
         *
         * Default Value: `Kilometers`
         */
        public var distanceUnit: aws.sdk.kotlin.services.location.model.DistanceUnit? = null
        /**
         * Set to include the geometry details in the result for each path between a pair of positions.
         *
         * Default Value: `false`
         *
         * Valid Values: `false` | `true`
         */
        public var includeLegGeometry: kotlin.Boolean? = null
        /**
         * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
         */
        public var key: kotlin.String? = null
        /**
         * Specifies the distance to optimize for when calculating a route.
         */
        public var optimizeFor: aws.sdk.kotlin.services.location.model.OptimizationMode? = null
        /**
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility. You can choose `Car`, `Truck`, `Walking`, `Bicycle` or `Motorcycle` as options for the `TravelMode`.
         *
         * `Bicycle` and `Motorcycle` are only valid when using Grab as a data provider, and only within Southeast Asia.
         *
         * `Truck` is not available for Grab.
         *
         * For more details on the using Grab for routing, including areas of coverage, see [GrabMaps](https://docs.aws.amazon.com/location/previous/developerguide/grab.html) in the *Amazon Location Service Developer Guide*.
         *
         * The `TravelMode` you specify also determines how you specify route preferences:
         * + If traveling by `Car` use the `CarModeOptions` parameter.
         * + If traveling by `Truck` use the `TruckModeOptions` parameter.
         *
         * Default Value: `Car`
         */
        public var travelMode: aws.sdk.kotlin.services.location.model.TravelMode? = null
        /**
         * Specifies route preferences when traveling by `Truck`, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.
         *
         * Requirements: `TravelMode` must be specified as `Truck`.
         */
        public var truckModeOptions: aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions? = null
        /**
         * Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position.
         * + For example, from the `DeparturePosition``[-123.115, 49.285]`, the route follows the order that the waypoint positions are given `[[-122.757, 49.0021],[-122.349, 47.620]]`
         *
         * If you specify a waypoint position that's not located on a road, Amazon Location [moves the position to the nearest road](https://docs.aws.amazon.com/location/previous/developerguide/snap-to-nearby-road.html).
         *
         * Specifying more than 23 waypoints returns a `400 ValidationException` error.
         *
         * If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a `400 RoutesValidationException` error.
         *
         * Valid Values: `[-180 to 180,-90 to 90]`
         */
        public var waypointPositions: List<List<Double>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CalculateRouteRequest) : this() {
            this.arrivalTime = x.arrivalTime
            this.calculatorName = x.calculatorName
            this.carModeOptions = x.carModeOptions
            this.departNow = x.departNow
            this.departurePosition = x.departurePosition
            this.departureTime = x.departureTime
            this.destinationPosition = x.destinationPosition
            this.distanceUnit = x.distanceUnit
            this.includeLegGeometry = x.includeLegGeometry
            this.key = x.key
            this.optimizeFor = x.optimizeFor
            this.travelMode = x.travelMode
            this.truckModeOptions = x.truckModeOptions
            this.waypointPositions = x.waypointPositions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CalculateRouteRequest = CalculateRouteRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions] inside the given [block]
         */
        public fun carModeOptions(block: aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions.Builder.() -> kotlin.Unit) {
            this.carModeOptions = awsSdkKotlinServicesLocationModelCalculateRouteCarModeOptionsDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions] inside the given [block]
         */
        public fun truckModeOptions(block: aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions.Builder.() -> kotlin.Unit) {
            this.truckModeOptions = awsSdkKotlinServicesLocationModelCalculateRouteTruckModeOptionsDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (calculatorName == null) calculatorName = ""
            if (departurePosition == null) departurePosition = emptyList()
            if (destinationPosition == null) destinationPosition = emptyList()
            return this
        }
    }
}
