// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.serde

import aws.sdk.kotlin.services.location.model.GeofenceGeometry
import aws.sdk.kotlin.services.location.model.PutGeofenceRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutGeofenceOperationSerializer: HttpSerializer.NonStreaming<PutGeofenceRequest> {
    override fun serialize(context: ExecutionContext, input: PutGeofenceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("geofencing"))
                add(PercentEncoding.Path.encode("v0"))
                add(PercentEncoding.Path.encode("collections"))
                add(PercentEncoding.SmithyLabel.encode(input.collectionName))
                add(PercentEncoding.Path.encode("geofences"))
                add(PercentEncoding.SmithyLabel.encode(input.geofenceId))
            }
        }

        val payload = serializePutGeofenceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutGeofenceOperationBody(context: ExecutionContext, input: PutGeofenceRequest): ByteArray {
    val serializer = JsonSerializer()
    val GEOFENCEPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("GeofenceProperties"))
    val GEOMETRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Geometry"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GEOFENCEPROPERTIES_DESCRIPTOR)
        field(GEOMETRY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.geofenceProperties != null) {
            mapField(GEOFENCEPROPERTIES_DESCRIPTOR) {
                input.geofenceProperties.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.geometry?.let { field(GEOMETRY_DESCRIPTOR, it, ::serializeGeofenceGeometryDocument) }
    }
    return serializer.toByteArray()
}
