// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.serde

import aws.sdk.kotlin.services.location.model.DescribeTrackerResponse
import aws.sdk.kotlin.services.location.model.LocationException
import aws.sdk.kotlin.services.location.model.PositionFiltering
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class DescribeTrackerOperationDeserializer: HttpDeserializer.NonStreaming<DescribeTrackerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeTrackerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTrackerError(context, call, payload)
        }
        val builder = DescribeTrackerResponse.Builder()

        if (payload != null) {
            deserializeDescribeTrackerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeTrackerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LocationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LocationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTrackerOperationBody(builder: DescribeTrackerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val EVENTBRIDGEENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EventBridgeEnabled"))
    val KMSKEYENABLEGEOSPATIALQUERIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("KmsKeyEnableGeospatialQueries"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val POSITIONFILTERING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PositionFiltering"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val TRACKERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrackerArn"))
    val TRACKERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrackerName"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EVENTBRIDGEENABLED_DESCRIPTOR)
        field(KMSKEYENABLEGEOSPATIALQUERIES_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(POSITIONFILTERING_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRACKERARN_DESCRIPTOR)
        field(TRACKERNAME_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeInstant(TimestampFormat.ISO_8601)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EVENTBRIDGEENABLED_DESCRIPTOR.index -> builder.eventBridgeEnabled = deserializeBoolean()
                KMSKEYENABLEGEOSPATIALQUERIES_DESCRIPTOR.index -> builder.kmsKeyEnableGeospatialQueries = deserializeBoolean()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                POSITIONFILTERING_DESCRIPTOR.index -> builder.positionFiltering = deserializeString().let { PositionFiltering.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TRACKERARN_DESCRIPTOR.index -> builder.trackerArn = deserializeString()
                TRACKERNAME_DESCRIPTOR.index -> builder.trackerName = deserializeString()
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeInstant(TimestampFormat.ISO_8601)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
