// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SearchPlaceIndexForPositionRequest private constructor(builder: Builder) {
    /**
     * The name of the place index resource you want to use for the search.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The preferred language used to return results. The value must be a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
     *
     * This setting affects the languages used in the results, but not the results themselves. If no language is specified, or not supported for a particular result, the partner automatically chooses a language for the result.
     *
     * For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the `language` parameter set to `en`. The `city` in the results will most likely be returned as `Athens`.
     *
     * If you set the `language` parameter to `el`, for Greek, then the `city` in the results will more likely be returned as `Αθήνα`.
     *
     * If the data provider does not have a value for Greek, the result will be in a language that the provider does support.
     */
    public val language: kotlin.String? = builder.language
    /**
     * An optional parameter. The maximum number of results returned per request.
     *
     * Default value: `50`
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Specifies the longitude and latitude of the position to query.
     *
     *  This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.
     *
     * For example, `[-123.1174, 49.2847]` represents a position with longitude `-123.1174` and latitude `49.2847`.
     */
    public val position: List<Double> = requireNotNull(builder.position) { "A non-null value must be provided for position" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchPlaceIndexForPositionRequest(")
        append("indexName=$indexName,")
        append("key=*** Sensitive Data Redacted ***,")
        append("language=$language,")
        append("maxResults=$maxResults,")
        append("position=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexName.hashCode()
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (position.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchPlaceIndexForPositionRequest

        if (indexName != other.indexName) return false
        if (key != other.key) return false
        if (language != other.language) return false
        if (maxResults != other.maxResults) return false
        if (position != other.position) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the place index resource you want to use for the search.
         */
        public var indexName: kotlin.String? = null
        /**
         * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
         */
        public var key: kotlin.String? = null
        /**
         * The preferred language used to return results. The value must be a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
         *
         * This setting affects the languages used in the results, but not the results themselves. If no language is specified, or not supported for a particular result, the partner automatically chooses a language for the result.
         *
         * For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the `language` parameter set to `en`. The `city` in the results will most likely be returned as `Athens`.
         *
         * If you set the `language` parameter to `el`, for Greek, then the `city` in the results will more likely be returned as `Αθήνα`.
         *
         * If the data provider does not have a value for Greek, the result will be in a language that the provider does support.
         */
        public var language: kotlin.String? = null
        /**
         * An optional parameter. The maximum number of results returned per request.
         *
         * Default value: `50`
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Specifies the longitude and latitude of the position to query.
         *
         *  This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.
         *
         * For example, `[-123.1174, 49.2847]` represents a position with longitude `-123.1174` and latitude `49.2847`.
         */
        public var position: List<Double>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionRequest) : this() {
            this.indexName = x.indexName
            this.key = x.key
            this.language = x.language
            this.maxResults = x.maxResults
            this.position = x.position
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionRequest = SearchPlaceIndexForPositionRequest(this)

        internal fun correctErrors(): Builder {
            if (indexName == null) indexName = ""
            if (position == null) position = emptyList()
            return this
        }
    }
}
