// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A route calculator resource listed in your Amazon Web Services account.
 */
public class ListRouteCalculatorsResponseEntry private constructor(builder: Builder) {
    /**
     * The name of the route calculator resource.
     */
    public val calculatorName: kotlin.String = requireNotNull(builder.calculatorName) { "A non-null value must be provided for calculatorName" }
    /**
     * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     * + For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The data provider of traffic and road network data. Indicates one of the available providers:
     * + `Esri`
     * + `Grab`
     * + `Here`
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String = requireNotNull(builder.dataSource) { "A non-null value must be provided for dataSource" }
    /**
     * The optional description of the route calculator resource.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The timestamp when the route calculator resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     * + For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponseEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRouteCalculatorsResponseEntry(")
        append("calculatorName=$calculatorName,")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("dataSource=$dataSource,")
        append("description=$description,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = calculatorName.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (dataSource.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRouteCalculatorsResponseEntry

        if (calculatorName != other.calculatorName) return false
        if (createTime != other.createTime) return false
        if (dataSource != other.dataSource) return false
        if (description != other.description) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponseEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the route calculator resource.
         */
        public var calculatorName: kotlin.String? = null
        /**
         * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         * + For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data provider of traffic and road network data. Indicates one of the available providers:
         * + `Esri`
         * + `Grab`
         * + `Here`
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * The optional description of the route calculator resource.
         */
        public var description: kotlin.String? = null
        /**
         * The timestamp when the route calculator resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         * + For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponseEntry) : this() {
            this.calculatorName = x.calculatorName
            this.createTime = x.createTime
            this.dataSource = x.dataSource
            this.description = x.description
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponseEntry = ListRouteCalculatorsResponseEntry(this)

        internal fun correctErrors(): Builder {
            if (calculatorName == null) calculatorName = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (dataSource == null) dataSource = ""
            if (description == null) description = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
