// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details of an existing map resource in your Amazon Web Services account.
 */
public class ListMapsResponseEntry private constructor(builder: Builder) {
    /**
     * The timestamp for when the map resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * Specifies the data provider for the associated map tiles.
     */
    public val dataSource: kotlin.String = requireNotNull(builder.dataSource) { "A non-null value must be provided for dataSource" }
    /**
     * The description for the map resource.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The name of the associated map resource.
     */
    public val mapName: kotlin.String = requireNotNull(builder.mapName) { "A non-null value must be provided for mapName" }
    /**
     * The timestamp for when the map resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ListMapsResponseEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListMapsResponseEntry(")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("dataSource=$dataSource,")
        append("description=$description,")
        append("mapName=$mapName,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (dataSource.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (mapName.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListMapsResponseEntry

        if (createTime != other.createTime) return false
        if (dataSource != other.dataSource) return false
        if (description != other.description) return false
        if (mapName != other.mapName) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ListMapsResponseEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp for when the map resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the data provider for the associated map tiles.
         */
        public var dataSource: kotlin.String? = null
        /**
         * The description for the map resource.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the associated map resource.
         */
        public var mapName: kotlin.String? = null
        /**
         * The timestamp for when the map resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ListMapsResponseEntry) : this() {
            this.createTime = x.createTime
            this.dataSource = x.dataSource
            this.description = x.description
            this.mapName = x.mapName
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ListMapsResponseEntry = ListMapsResponseEntry(this)

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (dataSource == null) dataSource = ""
            if (description == null) description = ""
            if (mapName == null) mapName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
