// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetMapGlyphsRequest private constructor(builder: Builder) {
    /**
     * A comma-separated list of fonts to load glyphs from in order of preference. For example, `Noto Sans Regular, Arial Unicode`.
     *
     * Valid font stacks for [Esri](https://docs.aws.amazon.com/location/previous/developerguide/esri.html) styles:
     * + VectorEsriDarkGrayCanvas – `Ubuntu Medium Italic` | `Ubuntu Medium` | `Ubuntu Italic` | `Ubuntu Regular` | `Ubuntu Bold`
     * + VectorEsriLightGrayCanvas – `Ubuntu Italic` | `Ubuntu Regular` | `Ubuntu Light` | `Ubuntu Bold`
     * + VectorEsriTopographic – `Noto Sans Italic` | `Noto Sans Regular` | `Noto Sans Bold` | `Noto Serif Regular` | `Roboto Condensed Light Italic`
     * + VectorEsriStreets – `Arial Regular` | `Arial Italic` | `Arial Bold`
     * + VectorEsriNavigation – `Arial Regular` | `Arial Italic` | `Arial Bold`
     *
     * Valid font stacks for [HERE Technologies](https://docs.aws.amazon.com/location/previous/developerguide/HERE.html) styles:
     * + VectorHereContrast – `Fira GO Regular` | `Fira GO Bold`
     * + VectorHereExplore, VectorHereExploreTruck, HybridHereExploreSatellite – `Fira GO Italic` | `Fira GO Map` | `Fira GO Map Bold` | `Noto Sans CJK JP Bold` | `Noto Sans CJK JP Light` | `Noto Sans CJK JP Regular`
     *
     * Valid font stacks for [GrabMaps](https://docs.aws.amazon.com/location/previous/developerguide/grab.html) styles:
     * + VectorGrabStandardLight, VectorGrabStandardDark – `Noto Sans Regular` | `Noto Sans Medium` | `Noto Sans Bold`
     *
     * Valid font stacks for [Open Data](https://docs.aws.amazon.com/location/previous/developerguide/open-data.html) styles:
     * + VectorOpenDataStandardLight, VectorOpenDataStandardDark, VectorOpenDataVisualizationLight, VectorOpenDataVisualizationDark – `Amazon Ember Regular,Noto Sans Regular` | `Amazon Ember Bold,Noto Sans Bold` | `Amazon Ember Medium,Noto Sans Medium` | `Amazon Ember Regular Italic,Noto Sans Italic` | `Amazon Ember Condensed RC Regular,Noto Sans Regular` | `Amazon Ember Condensed RC Bold,Noto Sans Bold` | `Amazon Ember Regular,Noto Sans Regular,Noto Sans Arabic Regular` | `Amazon Ember Condensed RC Bold,Noto Sans Bold,Noto Sans Arabic Condensed Bold` | `Amazon Ember Bold,Noto Sans Bold,Noto Sans Arabic Bold` | `Amazon Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular` | `Amazon Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic Condensed Regular` | `Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium`
     *
     * The fonts used by the Open Data map styles are combined fonts that use `Amazon Ember` for most glyphs but `Noto Sans` for glyphs unsupported by `Amazon Ember`.
     */
    public val fontStack: kotlin.String = requireNotNull(builder.fontStack) { "A non-null value must be provided for fontStack" }
    /**
     * A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range `U+0000` to `00FF`. Must be aligned to multiples of 256.
     */
    public val fontUnicodeRange: kotlin.String = requireNotNull(builder.fontUnicodeRange) { "A non-null value must be provided for fontUnicodeRange" }
    /**
     * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The map resource associated with the glyph ﬁle.
     */
    public val mapName: kotlin.String = requireNotNull(builder.mapName) { "A non-null value must be provided for mapName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.GetMapGlyphsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMapGlyphsRequest(")
        append("fontStack=$fontStack,")
        append("fontUnicodeRange=$fontUnicodeRange,")
        append("key=*** Sensitive Data Redacted ***,")
        append("mapName=$mapName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fontStack.hashCode()
        result = 31 * result + (fontUnicodeRange.hashCode())
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (mapName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMapGlyphsRequest

        if (fontStack != other.fontStack) return false
        if (fontUnicodeRange != other.fontUnicodeRange) return false
        if (key != other.key) return false
        if (mapName != other.mapName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.GetMapGlyphsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A comma-separated list of fonts to load glyphs from in order of preference. For example, `Noto Sans Regular, Arial Unicode`.
         *
         * Valid font stacks for [Esri](https://docs.aws.amazon.com/location/previous/developerguide/esri.html) styles:
         * + VectorEsriDarkGrayCanvas – `Ubuntu Medium Italic` | `Ubuntu Medium` | `Ubuntu Italic` | `Ubuntu Regular` | `Ubuntu Bold`
         * + VectorEsriLightGrayCanvas – `Ubuntu Italic` | `Ubuntu Regular` | `Ubuntu Light` | `Ubuntu Bold`
         * + VectorEsriTopographic – `Noto Sans Italic` | `Noto Sans Regular` | `Noto Sans Bold` | `Noto Serif Regular` | `Roboto Condensed Light Italic`
         * + VectorEsriStreets – `Arial Regular` | `Arial Italic` | `Arial Bold`
         * + VectorEsriNavigation – `Arial Regular` | `Arial Italic` | `Arial Bold`
         *
         * Valid font stacks for [HERE Technologies](https://docs.aws.amazon.com/location/previous/developerguide/HERE.html) styles:
         * + VectorHereContrast – `Fira GO Regular` | `Fira GO Bold`
         * + VectorHereExplore, VectorHereExploreTruck, HybridHereExploreSatellite – `Fira GO Italic` | `Fira GO Map` | `Fira GO Map Bold` | `Noto Sans CJK JP Bold` | `Noto Sans CJK JP Light` | `Noto Sans CJK JP Regular`
         *
         * Valid font stacks for [GrabMaps](https://docs.aws.amazon.com/location/previous/developerguide/grab.html) styles:
         * + VectorGrabStandardLight, VectorGrabStandardDark – `Noto Sans Regular` | `Noto Sans Medium` | `Noto Sans Bold`
         *
         * Valid font stacks for [Open Data](https://docs.aws.amazon.com/location/previous/developerguide/open-data.html) styles:
         * + VectorOpenDataStandardLight, VectorOpenDataStandardDark, VectorOpenDataVisualizationLight, VectorOpenDataVisualizationDark – `Amazon Ember Regular,Noto Sans Regular` | `Amazon Ember Bold,Noto Sans Bold` | `Amazon Ember Medium,Noto Sans Medium` | `Amazon Ember Regular Italic,Noto Sans Italic` | `Amazon Ember Condensed RC Regular,Noto Sans Regular` | `Amazon Ember Condensed RC Bold,Noto Sans Bold` | `Amazon Ember Regular,Noto Sans Regular,Noto Sans Arabic Regular` | `Amazon Ember Condensed RC Bold,Noto Sans Bold,Noto Sans Arabic Condensed Bold` | `Amazon Ember Bold,Noto Sans Bold,Noto Sans Arabic Bold` | `Amazon Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular` | `Amazon Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic Condensed Regular` | `Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium`
         *
         * The fonts used by the Open Data map styles are combined fonts that use `Amazon Ember` for most glyphs but `Noto Sans` for glyphs unsupported by `Amazon Ember`.
         */
        public var fontStack: kotlin.String? = null
        /**
         * A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range `U+0000` to `00FF`. Must be aligned to multiples of 256.
         */
        public var fontUnicodeRange: kotlin.String? = null
        /**
         * The optional [API key](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html) to authorize the request.
         */
        public var key: kotlin.String? = null
        /**
         * The map resource associated with the glyph ﬁle.
         */
        public var mapName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.GetMapGlyphsRequest) : this() {
            this.fontStack = x.fontStack
            this.fontUnicodeRange = x.fontUnicodeRange
            this.key = x.key
            this.mapName = x.mapName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.GetMapGlyphsRequest = GetMapGlyphsRequest(this)

        internal fun correctErrors(): Builder {
            if (fontStack == null) fontStack = ""
            if (fontUnicodeRange == null) fontUnicodeRange = ""
            if (mapName == null) mapName = ""
            return this
        }
    }
}
