// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribePlaceIndexResponse private constructor(builder: Builder) {
    /**
     * The timestamp for when the place index resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The data provider of geospatial data. Values can be one of the following:
     * + `Esri`
     * + `Grab`
     * + `Here`
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String = requireNotNull(builder.dataSource) { "A non-null value must be provided for dataSource" }
    /**
     * The specified data storage option for requesting Places.
     */
    public val dataSourceConfiguration: aws.sdk.kotlin.services.location.model.DataSourceConfiguration? = builder.dataSourceConfiguration
    /**
     * The optional description for the place index resource.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex`
     */
    public val indexArn: kotlin.String = requireNotNull(builder.indexArn) { "A non-null value must be provided for indexArn" }
    /**
     * The name of the place index resource being described.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * Tags associated with place index resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timestamp for when the place index resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePlaceIndexResponse(")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("dataSource=$dataSource,")
        append("dataSourceConfiguration=$dataSourceConfiguration,")
        append("description=$description,")
        append("indexArn=$indexArn,")
        append("indexName=$indexName,")
        append("tags=$tags,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (dataSource.hashCode())
        result = 31 * result + (dataSourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description.hashCode())
        result = 31 * result + (indexArn.hashCode())
        result = 31 * result + (indexName.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePlaceIndexResponse

        if (createTime != other.createTime) return false
        if (dataSource != other.dataSource) return false
        if (dataSourceConfiguration != other.dataSourceConfiguration) return false
        if (description != other.description) return false
        if (indexArn != other.indexArn) return false
        if (indexName != other.indexName) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp for when the place index resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data provider of geospatial data. Values can be one of the following:
         * + `Esri`
         * + `Grab`
         * + `Here`
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * The specified data storage option for requesting Places.
         */
        public var dataSourceConfiguration: aws.sdk.kotlin.services.location.model.DataSourceConfiguration? = null
        /**
         * The optional description for the place index resource.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex`
         */
        public var indexArn: kotlin.String? = null
        /**
         * The name of the place index resource being described.
         */
        public var indexName: kotlin.String? = null
        /**
         * Tags associated with place index resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timestamp for when the place index resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse) : this() {
            this.createTime = x.createTime
            this.dataSource = x.dataSource
            this.dataSourceConfiguration = x.dataSourceConfiguration
            this.description = x.description
            this.indexArn = x.indexArn
            this.indexName = x.indexName
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse = DescribePlaceIndexResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.DataSourceConfiguration] inside the given [block]
         */
        public fun dataSourceConfiguration(block: aws.sdk.kotlin.services.location.model.DataSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.dataSourceConfiguration = aws.sdk.kotlin.services.location.model.DataSourceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (dataSource == null) dataSource = ""
            if (description == null) description = ""
            if (indexArn == null) indexArn = ""
            if (indexName == null) indexName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
