// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateRouteCalculatorResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:route-calculator/ExampleCalculator`
     */
    public val calculatorArn: kotlin.String = requireNotNull(builder.calculatorArn) { "A non-null value must be provided for calculatorArn" }
    /**
     * The name of the route calculator resource.
     * + For example, `ExampleRouteCalculator`.
     */
    public val calculatorName: kotlin.String = requireNotNull(builder.calculatorName) { "A non-null value must be provided for calculatorName" }
    /**
     * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     * + For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateRouteCalculatorResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRouteCalculatorResponse(")
        append("calculatorArn=$calculatorArn,")
        append("calculatorName=$calculatorName,")
        append("createTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = calculatorArn.hashCode()
        result = 31 * result + (calculatorName.hashCode())
        result = 31 * result + (createTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRouteCalculatorResponse

        if (calculatorArn != other.calculatorArn) return false
        if (calculatorName != other.calculatorName) return false
        if (createTime != other.createTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateRouteCalculatorResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:route-calculator/ExampleCalculator`
         */
        public var calculatorArn: kotlin.String? = null
        /**
         * The name of the route calculator resource.
         * + For example, `ExampleRouteCalculator`.
         */
        public var calculatorName: kotlin.String? = null
        /**
         * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         * + For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateRouteCalculatorResponse) : this() {
            this.calculatorArn = x.calculatorArn
            this.calculatorName = x.calculatorName
            this.createTime = x.createTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateRouteCalculatorResponse = CreateRouteCalculatorResponse(this)

        internal fun correctErrors(): Builder {
            if (calculatorArn == null) calculatorArn = ""
            if (calculatorName == null) calculatorName = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
