// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A circle on the earth, as defined by a center point and a radius.
 */
public class Circle private constructor(builder: Builder) {
    /**
     * A single point geometry, specifying the center of the circle, using [WGS 84](https://gisgeography.com/wgs84-world-geodetic-system/) coordinates, in the form `[longitude, latitude]`.
     */
    public val center: List<Double> = requireNotNull(builder.center) { "A non-null value must be provided for center" }
    /**
     * The radius of the circle in meters. Must be greater than zero and no larger than 100,000 (100 kilometers).
     */
    public val radius: kotlin.Double = requireNotNull(builder.radius) { "A non-null value must be provided for radius" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.Circle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Circle(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = center.hashCode()
        result = 31 * result + (radius.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Circle

        if (center != other.center) return false
        if (!(radius?.equals(other.radius) ?: (other.radius == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.Circle = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A single point geometry, specifying the center of the circle, using [WGS 84](https://gisgeography.com/wgs84-world-geodetic-system/) coordinates, in the form `[longitude, latitude]`.
         */
        public var center: List<Double>? = null
        /**
         * The radius of the circle in meters. Must be greater than zero and no larger than 100,000 (100 kilometers).
         */
        public var radius: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.Circle) : this() {
            this.center = x.center
            this.radius = x.radius
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.Circle = Circle(this)

        internal fun correctErrors(): Builder {
            if (center == null) center = emptyList()
            if (radius == null) radius = 0.0
            return this
        }
    }
}
