// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains geofence geometry details.
 */
public class BatchPutGeofenceRequestEntry private constructor(builder: Builder) {
    /**
     * The identifier for the geofence to be stored in a given geofence collection.
     */
    public val geofenceId: kotlin.String = requireNotNull(builder.geofenceId) { "A non-null value must be provided for geofenceId" }
    /**
     * Associates one of more properties with the geofence. A property is a key-value pair stored with the geofence and added to any geofence event triggered with that geofence.
     *
     * Format: `"key" : "value"`
     */
    public val geofenceProperties: Map<String, String>? = builder.geofenceProperties
    /**
     * Contains the details to specify the position of the geofence. Can be a circle, a polygon, or a multipolygon. `Polygon` and `MultiPolygon` geometries can be defined using their respective parameters, or encoded in Geobuf format using the `Geobuf` parameter. Including multiple geometry types in the same request will return a validation error.
     *
     * The geofence `Polygon` and `MultiPolygon` formats support a maximum of 1,000 total vertices. The `Geobuf` format supports a maximum of 100,000 vertices.
     */
    public val geometry: aws.sdk.kotlin.services.location.model.GeofenceGeometry? = builder.geometry

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.BatchPutGeofenceRequestEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchPutGeofenceRequestEntry(")
        append("geofenceId=$geofenceId,")
        append("geofenceProperties=*** Sensitive Data Redacted ***,")
        append("geometry=$geometry")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = geofenceId.hashCode()
        result = 31 * result + (geofenceProperties?.hashCode() ?: 0)
        result = 31 * result + (geometry?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchPutGeofenceRequestEntry

        if (geofenceId != other.geofenceId) return false
        if (geofenceProperties != other.geofenceProperties) return false
        if (geometry != other.geometry) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.BatchPutGeofenceRequestEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for the geofence to be stored in a given geofence collection.
         */
        public var geofenceId: kotlin.String? = null
        /**
         * Associates one of more properties with the geofence. A property is a key-value pair stored with the geofence and added to any geofence event triggered with that geofence.
         *
         * Format: `"key" : "value"`
         */
        public var geofenceProperties: Map<String, String>? = null
        /**
         * Contains the details to specify the position of the geofence. Can be a circle, a polygon, or a multipolygon. `Polygon` and `MultiPolygon` geometries can be defined using their respective parameters, or encoded in Geobuf format using the `Geobuf` parameter. Including multiple geometry types in the same request will return a validation error.
         *
         * The geofence `Polygon` and `MultiPolygon` formats support a maximum of 1,000 total vertices. The `Geobuf` format supports a maximum of 100,000 vertices.
         */
        public var geometry: aws.sdk.kotlin.services.location.model.GeofenceGeometry? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.BatchPutGeofenceRequestEntry) : this() {
            this.geofenceId = x.geofenceId
            this.geofenceProperties = x.geofenceProperties
            this.geometry = x.geometry
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.BatchPutGeofenceRequestEntry = BatchPutGeofenceRequestEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.GeofenceGeometry] inside the given [block]
         */
        public fun geometry(block: aws.sdk.kotlin.services.location.model.GeofenceGeometry.Builder.() -> kotlin.Unit) {
            this.geometry = aws.sdk.kotlin.services.location.model.GeofenceGeometry.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (geofenceId == null) geofenceId = ""
            return this
        }
    }
}
