// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.serde

import aws.sdk.kotlin.services.location.model.ApiKeyRestrictions
import aws.sdk.kotlin.services.location.model.UpdateKeyRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class UpdateKeyOperationSerializer: HttpSerializer.NonStreaming<UpdateKeyRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateKeyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("metadata"))
                add(PercentEncoding.Path.encode("v0"))
                add(PercentEncoding.Path.encode("keys"))
                add(PercentEncoding.SmithyLabel.encode(input.keyName))
            }
        }

        val payload = serializeUpdateKeyOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateKeyOperationBody(context: ExecutionContext, input: UpdateKeyRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val EXPIRETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExpireTime"))
    val FORCEUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ForceUpdate"))
    val NOEXPIRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("NoExpiry"))
    val RESTRICTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Restrictions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(EXPIRETIME_DESCRIPTOR)
        field(FORCEUPDATE_DESCRIPTOR)
        field(NOEXPIRY_DESCRIPTOR)
        field(RESTRICTIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.expireTime?.let { field(EXPIRETIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.forceUpdate?.let { field(FORCEUPDATE_DESCRIPTOR, it) }
        input.noExpiry?.let { field(NOEXPIRY_DESCRIPTOR, it) }
        input.restrictions?.let { field(RESTRICTIONS_DESCRIPTOR, it, ::serializeApiKeyRestrictionsDocument) }
    }
    return serializer.toByteArray()
}
