// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.serde

import aws.sdk.kotlin.services.location.model.DistanceUnit
import aws.sdk.kotlin.services.location.model.ForecastGeofenceEventsResponse
import aws.sdk.kotlin.services.location.model.ForecastedEvent
import aws.sdk.kotlin.services.location.model.LocationException
import aws.sdk.kotlin.services.location.model.SpeedUnit
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ForecastGeofenceEventsOperationDeserializer: HttpDeserializer.NonStreaming<ForecastGeofenceEventsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ForecastGeofenceEventsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwForecastGeofenceEventsError(context, call, payload)
        }
        val builder = ForecastGeofenceEventsResponse.Builder()

        if (payload != null) {
            deserializeForecastGeofenceEventsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwForecastGeofenceEventsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LocationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LocationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeForecastGeofenceEventsOperationBody(builder: ForecastGeofenceEventsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DISTANCEUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DistanceUnit"))
    val FORECASTEDEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ForecastedEvents"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SPEEDUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SpeedUnit"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DISTANCEUNIT_DESCRIPTOR)
        field(FORECASTEDEVENTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SPEEDUNIT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DISTANCEUNIT_DESCRIPTOR.index -> builder.distanceUnit = deserializeString().let { DistanceUnit.fromValue(it) }
                FORECASTEDEVENTS_DESCRIPTOR.index -> builder.forecastedEvents =
                    deserializer.deserializeList(FORECASTEDEVENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ForecastedEvent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeForecastedEventDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SPEEDUNIT_DESCRIPTOR.index -> builder.speedUnit = deserializeString().let { SpeedUnit.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
