// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class UpdateKeyRequest private constructor(builder: Builder) {
    /**
     * Updates the description for the API key resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Updates the timestamp for when the API key resource will expire in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val expireTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expireTime
    /**
     * The boolean flag to be included for updating `ExpireTime` or `Restrictions` details.
     *
     * Must be set to `true` to update an API key resource that has been used in the past 7 days.
     *
     * `False` if force update is not preferred
     *
     * Default value: `False`
     */
    public val forceUpdate: kotlin.Boolean? = builder.forceUpdate
    /**
     * The name of the API key resource to update.
     */
    public val keyName: kotlin.String = requireNotNull(builder.keyName) { "A non-null value must be provided for keyName" }
    /**
     * Whether the API key should expire. Set to `true` to set the API key to have no expiration time.
     */
    public val noExpiry: kotlin.Boolean? = builder.noExpiry
    /**
     * Updates the API key restrictions for the API key resource.
     */
    public val restrictions: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions? = builder.restrictions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.UpdateKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateKeyRequest(")
        append("description=$description,")
        append("expireTime=$expireTime,")
        append("forceUpdate=$forceUpdate,")
        append("keyName=$keyName,")
        append("noExpiry=$noExpiry,")
        append("restrictions=$restrictions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (expireTime?.hashCode() ?: 0)
        result = 31 * result + (forceUpdate?.hashCode() ?: 0)
        result = 31 * result + (keyName.hashCode())
        result = 31 * result + (noExpiry?.hashCode() ?: 0)
        result = 31 * result + (restrictions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateKeyRequest

        if (description != other.description) return false
        if (expireTime != other.expireTime) return false
        if (forceUpdate != other.forceUpdate) return false
        if (keyName != other.keyName) return false
        if (noExpiry != other.noExpiry) return false
        if (restrictions != other.restrictions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.UpdateKeyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Updates the description for the API key resource.
         */
        public var description: kotlin.String? = null
        /**
         * Updates the timestamp for when the API key resource will expire in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var expireTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The boolean flag to be included for updating `ExpireTime` or `Restrictions` details.
         *
         * Must be set to `true` to update an API key resource that has been used in the past 7 days.
         *
         * `False` if force update is not preferred
         *
         * Default value: `False`
         */
        public var forceUpdate: kotlin.Boolean? = null
        /**
         * The name of the API key resource to update.
         */
        public var keyName: kotlin.String? = null
        /**
         * Whether the API key should expire. Set to `true` to set the API key to have no expiration time.
         */
        public var noExpiry: kotlin.Boolean? = null
        /**
         * Updates the API key restrictions for the API key resource.
         */
        public var restrictions: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.UpdateKeyRequest) : this() {
            this.description = x.description
            this.expireTime = x.expireTime
            this.forceUpdate = x.forceUpdate
            this.keyName = x.keyName
            this.noExpiry = x.noExpiry
            this.restrictions = x.restrictions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.UpdateKeyRequest = UpdateKeyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.ApiKeyRestrictions] inside the given [block]
         */
        public fun restrictions(block: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions.Builder.() -> kotlin.Unit) {
            this.restrictions = aws.sdk.kotlin.services.location.model.ApiKeyRestrictions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (keyName == null) keyName = ""
            return this
        }
    }
}
