// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class UpdateGeofenceCollectionResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection`
     */
    public val collectionArn: kotlin.String = requireNotNull(builder.collectionArn) { "A non-null value must be provided for collectionArn" }
    /**
     * The name of the updated geofence collection.
     */
    public val collectionName: kotlin.String = requireNotNull(builder.collectionName) { "A non-null value must be provided for collectionName" }
    /**
     * The time when the geofence collection was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.UpdateGeofenceCollectionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGeofenceCollectionResponse(")
        append("collectionArn=$collectionArn,")
        append("collectionName=$collectionName,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionArn.hashCode()
        result = 31 * result + (collectionName.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateGeofenceCollectionResponse

        if (collectionArn != other.collectionArn) return false
        if (collectionName != other.collectionName) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.UpdateGeofenceCollectionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection`
         */
        public var collectionArn: kotlin.String? = null
        /**
         * The name of the updated geofence collection.
         */
        public var collectionName: kotlin.String? = null
        /**
         * The time when the geofence collection was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.UpdateGeofenceCollectionResponse) : this() {
            this.collectionArn = x.collectionArn
            this.collectionName = x.collectionName
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.UpdateGeofenceCollectionResponse = UpdateGeofenceCollectionResponse(this)

        internal fun correctErrors(): Builder {
            if (collectionArn == null) collectionArn = ""
            if (collectionName == null) collectionName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
