// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains a place suggestion resulting from a place suggestion query that is run on a place index resource.
 */
public class SearchForSuggestionsResult private constructor(builder: Builder) {
    /**
     * The Amazon Location categories that describe the Place.
     *
     * For more information about using categories, including a list of Amazon Location categories, see [Categories and filtering](https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html), in the *Amazon Location Service Developer Guide*.
     */
    public val categories: List<String>? = builder.categories
    /**
     * The unique identifier of the Place. You can use this with the `GetPlace` operation to find the place again later, or to get full information for the Place.
     *
     * The `GetPlace` request must use the same `PlaceIndex` resource as the `SearchPlaceIndexForSuggestions` that generated the Place ID.
     *
     * For `SearchPlaceIndexForSuggestions` operations, the `PlaceId` is returned by place indexes that use Esri, Grab, or HERE as data providers.
     */
    public val placeId: kotlin.String? = builder.placeId
    /**
     * Categories from the data provider that describe the Place that are not mapped to any Amazon Location categories.
     */
    public val supplementalCategories: List<String>? = builder.supplementalCategories
    /**
     * The text of the place suggestion, typically formatted as an address string.
     */
    public val text: kotlin.String = requireNotNull(builder.text) { "A non-null value must be provided for text" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.SearchForSuggestionsResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchForSuggestionsResult(")
        append("categories=$categories,")
        append("placeId=$placeId,")
        append("supplementalCategories=$supplementalCategories,")
        append("text=$text")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = categories?.hashCode() ?: 0
        result = 31 * result + (placeId?.hashCode() ?: 0)
        result = 31 * result + (supplementalCategories?.hashCode() ?: 0)
        result = 31 * result + (text.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchForSuggestionsResult

        if (categories != other.categories) return false
        if (placeId != other.placeId) return false
        if (supplementalCategories != other.supplementalCategories) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.SearchForSuggestionsResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Location categories that describe the Place.
         *
         * For more information about using categories, including a list of Amazon Location categories, see [Categories and filtering](https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html), in the *Amazon Location Service Developer Guide*.
         */
        public var categories: List<String>? = null
        /**
         * The unique identifier of the Place. You can use this with the `GetPlace` operation to find the place again later, or to get full information for the Place.
         *
         * The `GetPlace` request must use the same `PlaceIndex` resource as the `SearchPlaceIndexForSuggestions` that generated the Place ID.
         *
         * For `SearchPlaceIndexForSuggestions` operations, the `PlaceId` is returned by place indexes that use Esri, Grab, or HERE as data providers.
         */
        public var placeId: kotlin.String? = null
        /**
         * Categories from the data provider that describe the Place that are not mapped to any Amazon Location categories.
         */
        public var supplementalCategories: List<String>? = null
        /**
         * The text of the place suggestion, typically formatted as an address string.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.SearchForSuggestionsResult) : this() {
            this.categories = x.categories
            this.placeId = x.placeId
            this.supplementalCategories = x.supplementalCategories
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.SearchForSuggestionsResult = SearchForSuggestionsResult(this)

        internal fun correctErrors(): Builder {
            if (text == null) text = ""
            return this
        }
    }
}
